/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ElementCollection;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.IModelStore;

public class Bundle
extends ElementCollection {
    public Bundle() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public Bundle(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public Bundle(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected Bundle(BundleBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.setContext(builder.context);
    }

    @Override
    public String getType() {
        return "Core.Bundle";
    }

    @Override
    public Bundle setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public Bundle setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public Bundle setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    public Optional<String> getContext() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_CONTEXT);
    }

    public Bundle setContext(@Nullable String context) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_CONTEXT, context);
        return this;
    }

    @Override
    public Bundle setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public Bundle setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Optional<String> optional = this.getContext();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting context for Bundle: " + e.getMessage());
        }
        return retval;
    }

    public static class BundleBuilder
    extends ElementCollection.ElementCollectionBuilder {
        protected String context = null;

        public BundleBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public BundleBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public BundleBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public BundleBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public BundleBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public BundleBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public BundleBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public BundleBuilder addRootElement(Element rootElement) {
            if (Objects.nonNull((Object)rootElement)) {
                this.rootElements.add(rootElement);
            }
            return this;
        }

        @Override
        public BundleBuilder addAllRootElement(Collection<Element> rootElementCollection) {
            if (Objects.nonNull(rootElementCollection)) {
                this.rootElements.addAll(rootElementCollection);
            }
            return this;
        }

        @Override
        public BundleBuilder addElement(Element element) {
            if (Objects.nonNull((Object)element)) {
                this.elements.add(element);
            }
            return this;
        }

        @Override
        public BundleBuilder addAllElement(Collection<Element> elementCollection) {
            if (Objects.nonNull(elementCollection)) {
                this.elements.addAll(elementCollection);
            }
            return this;
        }

        @Override
        public BundleBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public BundleBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public BundleBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public BundleBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public BundleBuilder addProfileConformance(ProfileIdentifierType profileConformance) {
            if (Objects.nonNull((Object)profileConformance)) {
                this.profileConformances.add(profileConformance);
            }
            return this;
        }

        @Override
        public BundleBuilder addAllProfileConformance(Collection<ProfileIdentifierType> profileConformanceCollection) {
            if (Objects.nonNull(profileConformanceCollection)) {
                this.profileConformances.addAll(profileConformanceCollection);
            }
            return this;
        }

        @Override
        public BundleBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public BundleBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public BundleBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public BundleBuilder setContext(String context) {
            this.context = context;
            return this;
        }

        @Override
        public BundleBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public BundleBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Bundle build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                Bundle bundle = new Bundle(this);
                return bundle;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

