/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.DictionaryEntry;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.Hash;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.IModelStore;

public class Build
extends Element {
    Collection<DictionaryEntry> environments = Collections.emptyList();
    Collection<Hash> configSourceDigests = Collections.emptyList();
    Collection<DictionaryEntry> parameters = Collections.emptyList();
    Collection<String> configSourceEntrypoints = Collections.emptyList();
    Collection<String> configSourceUris = Collections.emptyList();

    public Build() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public Build(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public Build(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.environments = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ENVIRONMENT, DictionaryEntry.class);
        }
        if (!this.isExternal()) {
            this.configSourceDigests = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CONFIG_SOURCE_DIGEST, Hash.class);
        }
        if (!this.isExternal()) {
            this.parameters = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_PARAMETER, DictionaryEntry.class);
        }
        if (!this.isExternal()) {
            this.configSourceEntrypoints = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CONFIG_SOURCE_ENTRYPOINT, String.class);
        }
        if (!this.isExternal()) {
            this.configSourceUris = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CONFIG_SOURCE_URI, String.class);
        }
    }

    protected Build(BuildBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.environments = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ENVIRONMENT, DictionaryEntry.class);
        this.configSourceDigests = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CONFIG_SOURCE_DIGEST, Hash.class);
        this.parameters = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_PARAMETER, DictionaryEntry.class);
        this.configSourceEntrypoints = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CONFIG_SOURCE_ENTRYPOINT, String.class);
        this.configSourceUris = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CONFIG_SOURCE_URI, String.class);
        this.getEnvironments().addAll(builder.environments);
        this.getConfigSourceDigests().addAll(builder.configSourceDigests);
        this.getParameters().addAll(builder.parameters);
        this.getConfigSourceEntrypoints().addAll(builder.configSourceEntrypoints);
        this.getConfigSourceUris().addAll(builder.configSourceUris);
        this.setBuildId(builder.buildId);
        this.setBuildEndTime(builder.buildEndTime);
        this.setBuildStartTime(builder.buildStartTime);
        if (Objects.nonNull(builder.buildType)) {
            this.setBuildType(builder.buildType);
        }
    }

    @Override
    public String getType() {
        return "Build.Build";
    }

    public Collection<DictionaryEntry> getEnvironments() {
        return this.environments;
    }

    public Collection<Hash> getConfigSourceDigests() {
        return this.configSourceDigests;
    }

    public Collection<DictionaryEntry> getParameters() {
        return this.parameters;
    }

    public Collection<String> getConfigSourceEntrypoints() {
        return this.configSourceEntrypoints;
    }

    public Collection<String> getConfigSourceUris() {
        return this.configSourceUris;
    }

    @Override
    public Build setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    public Optional<String> getBuildId() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_BUILD_ID);
    }

    public Build setBuildId(@Nullable String buildId) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_BUILD_ID, buildId);
        return this;
    }

    public Optional<String> getBuildEndTime() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_BUILD_END_TIME);
    }

    public Build setBuildEndTime(@Nullable String buildEndTime) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.nonNull(buildEndTime) && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", buildEndTime)) {
            throw new InvalidSPDXAnalysisException("buildEndTime value '" + buildEndTime + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_BUILD_END_TIME, buildEndTime);
        return this;
    }

    @Override
    public Build setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public Build setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public Build setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public Build setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    public Optional<String> getBuildStartTime() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_BUILD_START_TIME);
    }

    public Build setBuildStartTime(@Nullable String buildStartTime) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.nonNull(buildStartTime) && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", buildStartTime)) {
            throw new InvalidSPDXAnalysisException("buildStartTime value '" + buildStartTime + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_BUILD_START_TIME, buildStartTime);
        return this;
    }

    @Nullable
    public String getBuildType() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_BUILD_TYPE);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public Build setBuildType(@Nullable String buildType) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(buildType)) {
            throw new InvalidSPDXAnalysisException("buildType is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_BUILD_TYPE, buildType);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Iterator<ModelObjectV3> iterator = this.getBuildId();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting buildId for Build: " + e.getMessage());
        }
        try {
            Optional<String> buildEndTime = this.getBuildEndTime();
            if (buildEndTime.isPresent() && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", buildEndTime.get())) {
                retval.add("buildEndTime value '" + buildEndTime.get() + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting buildEndTime for Build: " + e.getMessage());
        }
        try {
            Optional<String> buildStartTime = this.getBuildStartTime();
            if (buildStartTime.isPresent() && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", buildStartTime.get())) {
                retval.add("buildStartTime value '" + buildStartTime.get() + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting buildStartTime for Build: " + e.getMessage());
        }
        try {
            String buildType = this.getBuildType();
            if (Objects.isNull(buildType) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.BUILD))) {
                retval.add("Missing buildType in Build");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting buildType for Build: " + e.getMessage());
        }
        for (DictionaryEntry environment : this.environments) {
            retval.addAll(environment.verify(verifiedIds, specVersionForVerify, profiles));
        }
        for (Hash configSourceDigest : this.configSourceDigests) {
            retval.addAll(configSourceDigest.verify(verifiedIds, specVersionForVerify, profiles));
        }
        for (DictionaryEntry parameter : this.parameters) {
            retval.addAll(parameter.verify(verifiedIds, specVersionForVerify, profiles));
        }
        return retval;
    }

    public static class BuildBuilder
    extends Element.ElementBuilder {
        protected Collection<DictionaryEntry> environments = new ArrayList<DictionaryEntry>();
        protected Collection<Hash> configSourceDigests = new ArrayList<Hash>();
        protected Collection<DictionaryEntry> parameters = new ArrayList<DictionaryEntry>();
        protected Collection<String> configSourceEntrypoints = new ArrayList<String>();
        protected Collection<String> configSourceUris = new ArrayList<String>();
        protected String buildId = null;
        protected String buildEndTime = null;
        protected String buildStartTime = null;
        protected String buildType = null;

        public BuildBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public BuildBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public BuildBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public BuildBuilder addEnvironment(DictionaryEntry environment) {
            if (Objects.nonNull((Object)environment)) {
                this.environments.add(environment);
            }
            return this;
        }

        public BuildBuilder addAllEnvironment(Collection<DictionaryEntry> environmentCollection) {
            if (Objects.nonNull(environmentCollection)) {
                this.environments.addAll(environmentCollection);
            }
            return this;
        }

        @Override
        public BuildBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public BuildBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public BuildBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public BuildBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public BuildBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public BuildBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        public BuildBuilder addConfigSourceDigest(Hash configSourceDigest) {
            if (Objects.nonNull((Object)configSourceDigest)) {
                this.configSourceDigests.add(configSourceDigest);
            }
            return this;
        }

        public BuildBuilder addAllConfigSourceDigest(Collection<Hash> configSourceDigestCollection) {
            if (Objects.nonNull(configSourceDigestCollection)) {
                this.configSourceDigests.addAll(configSourceDigestCollection);
            }
            return this;
        }

        public BuildBuilder addParameter(DictionaryEntry parameter) {
            if (Objects.nonNull((Object)parameter)) {
                this.parameters.add(parameter);
            }
            return this;
        }

        public BuildBuilder addAllParameter(Collection<DictionaryEntry> parameterCollection) {
            if (Objects.nonNull(parameterCollection)) {
                this.parameters.addAll(parameterCollection);
            }
            return this;
        }

        @Override
        public BuildBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public BuildBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        public BuildBuilder addConfigSourceEntrypoint(String configSourceEntrypoint) {
            if (Objects.nonNull(configSourceEntrypoint)) {
                this.configSourceEntrypoints.add(configSourceEntrypoint);
            }
            return this;
        }

        public BuildBuilder addAllConfigSourceEntrypoint(Collection<String> configSourceEntrypointCollection) {
            if (Objects.nonNull(configSourceEntrypointCollection)) {
                this.configSourceEntrypoints.addAll(configSourceEntrypointCollection);
            }
            return this;
        }

        public BuildBuilder addConfigSourceUri(String configSourceUri) {
            if (Objects.nonNull(configSourceUri)) {
                this.configSourceUris.add(configSourceUri);
            }
            return this;
        }

        public BuildBuilder addAllConfigSourceUri(Collection<String> configSourceUriCollection) {
            if (Objects.nonNull(configSourceUriCollection)) {
                this.configSourceUris.addAll(configSourceUriCollection);
            }
            return this;
        }

        @Override
        public BuildBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        public BuildBuilder setBuildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        public BuildBuilder setBuildEndTime(String buildEndTime) {
            this.buildEndTime = buildEndTime;
            return this;
        }

        @Override
        public BuildBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public BuildBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public BuildBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public BuildBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public BuildBuilder setBuildStartTime(String buildStartTime) {
            this.buildStartTime = buildStartTime;
            return this;
        }

        public BuildBuilder setBuildType(String buildType) {
            this.buildType = buildType;
            return this;
        }

        @Override
        public Build build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                Build build = new Build(this);
                return build;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

