/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.ai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.ai.EnergyConsumptionDescription;
import org.spdx.storage.IModelStore;

public class EnergyConsumption
extends ModelObjectV3 {
    Collection<EnergyConsumptionDescription> trainingEnergyConsumptions = Collections.emptyList();
    Collection<EnergyConsumptionDescription> finetuningEnergyConsumptions = Collections.emptyList();
    Collection<EnergyConsumptionDescription> inferenceEnergyConsumptions = Collections.emptyList();

    public EnergyConsumption() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public EnergyConsumption(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public EnergyConsumption(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.trainingEnergyConsumptions = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_TRAINING_ENERGY_CONSUMPTION, EnergyConsumptionDescription.class);
        }
        if (!this.isExternal()) {
            this.finetuningEnergyConsumptions = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_FINETUNING_ENERGY_CONSUMPTION, EnergyConsumptionDescription.class);
        }
        if (!this.isExternal()) {
            this.inferenceEnergyConsumptions = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_INFERENCE_ENERGY_CONSUMPTION, EnergyConsumptionDescription.class);
        }
    }

    protected EnergyConsumption(EnergyConsumptionBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.trainingEnergyConsumptions = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_TRAINING_ENERGY_CONSUMPTION, EnergyConsumptionDescription.class);
        this.finetuningEnergyConsumptions = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_FINETUNING_ENERGY_CONSUMPTION, EnergyConsumptionDescription.class);
        this.inferenceEnergyConsumptions = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_INFERENCE_ENERGY_CONSUMPTION, EnergyConsumptionDescription.class);
        this.getTrainingEnergyConsumptions().addAll(builder.trainingEnergyConsumptions);
        this.getFinetuningEnergyConsumptions().addAll(builder.finetuningEnergyConsumptions);
        this.getInferenceEnergyConsumptions().addAll(builder.inferenceEnergyConsumptions);
    }

    public String getType() {
        return "AI.EnergyConsumption";
    }

    public Collection<EnergyConsumptionDescription> getTrainingEnergyConsumptions() {
        return this.trainingEnergyConsumptions;
    }

    public Collection<EnergyConsumptionDescription> getFinetuningEnergyConsumptions() {
        return this.finetuningEnergyConsumptions;
    }

    public Collection<EnergyConsumptionDescription> getInferenceEnergyConsumptions() {
        return this.inferenceEnergyConsumptions;
    }

    public String toString() {
        return "EnergyConsumption: " + this.getObjectUri();
    }

    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        for (EnergyConsumptionDescription trainingEnergyConsumption : this.trainingEnergyConsumptions) {
            retval.addAll(trainingEnergyConsumption.verify(verifiedIds, specVersionForVerify, profiles));
        }
        for (EnergyConsumptionDescription finetuningEnergyConsumption : this.finetuningEnergyConsumptions) {
            retval.addAll(finetuningEnergyConsumption.verify(verifiedIds, specVersionForVerify, profiles));
        }
        for (EnergyConsumptionDescription inferenceEnergyConsumption : this.inferenceEnergyConsumptions) {
            retval.addAll(inferenceEnergyConsumption.verify(verifiedIds, specVersionForVerify, profiles));
        }
        return retval;
    }

    public static class EnergyConsumptionBuilder
    extends ModelObjectV3.ModelObjectV3Builder {
        protected Collection<EnergyConsumptionDescription> trainingEnergyConsumptions = new ArrayList<EnergyConsumptionDescription>();
        protected Collection<EnergyConsumptionDescription> finetuningEnergyConsumptions = new ArrayList<EnergyConsumptionDescription>();
        protected Collection<EnergyConsumptionDescription> inferenceEnergyConsumptions = new ArrayList<EnergyConsumptionDescription>();

        public EnergyConsumptionBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public EnergyConsumptionBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
        }

        public EnergyConsumptionBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public EnergyConsumptionBuilder addTrainingEnergyConsumption(EnergyConsumptionDescription trainingEnergyConsumption) {
            if (Objects.nonNull((Object)trainingEnergyConsumption)) {
                this.trainingEnergyConsumptions.add(trainingEnergyConsumption);
            }
            return this;
        }

        public EnergyConsumptionBuilder addAllTrainingEnergyConsumption(Collection<EnergyConsumptionDescription> trainingEnergyConsumptionCollection) {
            if (Objects.nonNull(trainingEnergyConsumptionCollection)) {
                this.trainingEnergyConsumptions.addAll(trainingEnergyConsumptionCollection);
            }
            return this;
        }

        public EnergyConsumptionBuilder addFinetuningEnergyConsumption(EnergyConsumptionDescription finetuningEnergyConsumption) {
            if (Objects.nonNull((Object)finetuningEnergyConsumption)) {
                this.finetuningEnergyConsumptions.add(finetuningEnergyConsumption);
            }
            return this;
        }

        public EnergyConsumptionBuilder addAllFinetuningEnergyConsumption(Collection<EnergyConsumptionDescription> finetuningEnergyConsumptionCollection) {
            if (Objects.nonNull(finetuningEnergyConsumptionCollection)) {
                this.finetuningEnergyConsumptions.addAll(finetuningEnergyConsumptionCollection);
            }
            return this;
        }

        public EnergyConsumptionBuilder addInferenceEnergyConsumption(EnergyConsumptionDescription inferenceEnergyConsumption) {
            if (Objects.nonNull((Object)inferenceEnergyConsumption)) {
                this.inferenceEnergyConsumptions.add(inferenceEnergyConsumption);
            }
            return this;
        }

        public EnergyConsumptionBuilder addAllInferenceEnergyConsumption(Collection<EnergyConsumptionDescription> inferenceEnergyConsumptionCollection) {
            if (Objects.nonNull(inferenceEnergyConsumptionCollection)) {
                this.inferenceEnergyConsumptions.addAll(inferenceEnergyConsumptionCollection);
            }
            return this;
        }

        public EnergyConsumption build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                EnergyConsumption energyConsumption = new EnergyConsumption(this);
                return energyConsumption;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

