/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.ai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.ai.EnergyConsumption;
import org.spdx.library.model.v3_0_1.ai.SafetyRiskAssessmentType;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.DictionaryEntry;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.PresenceType;
import org.spdx.library.model.v3_0_1.core.SupportType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.software.ContentIdentifier;
import org.spdx.library.model.v3_0_1.software.SoftwarePurpose;
import org.spdx.library.model.v3_0_1.software.SpdxPackage;
import org.spdx.storage.IModelStore;

public class AIPackage
extends SpdxPackage {
    Collection<DictionaryEntry> hyperparameters = Collections.emptyList();
    Collection<DictionaryEntry> metrics = Collections.emptyList();
    Collection<DictionaryEntry> metricDecisionThresholds = Collections.emptyList();
    Collection<String> modelDataPreprocessings = Collections.emptyList();
    Collection<String> domains = Collections.emptyList();
    Collection<String> typeOfModels = Collections.emptyList();
    Collection<String> standardCompliances = Collections.emptyList();
    Collection<String> modelExplainabilitys = Collections.emptyList();

    public AIPackage() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public AIPackage(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public AIPackage(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.hyperparameters = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_HYPERPARAMETER, DictionaryEntry.class);
        }
        if (!this.isExternal()) {
            this.metrics = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_METRIC, DictionaryEntry.class);
        }
        if (!this.isExternal()) {
            this.metricDecisionThresholds = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_METRIC_DECISION_THRESHOLD, DictionaryEntry.class);
        }
        if (!this.isExternal()) {
            this.modelDataPreprocessings = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_MODEL_DATA_PREPROCESSING, String.class);
        }
        if (!this.isExternal()) {
            this.domains = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_DOMAIN, String.class);
        }
        if (!this.isExternal()) {
            this.typeOfModels = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_TYPE_OF_MODEL, String.class);
        }
        if (!this.isExternal()) {
            this.standardCompliances = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_STANDARD_COMPLIANCE, String.class);
        }
        if (!this.isExternal()) {
            this.modelExplainabilitys = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_MODEL_EXPLAINABILITY, String.class);
        }
    }

    protected AIPackage(AIPackageBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.hyperparameters = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_HYPERPARAMETER, DictionaryEntry.class);
        this.metrics = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_METRIC, DictionaryEntry.class);
        this.metricDecisionThresholds = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_METRIC_DECISION_THRESHOLD, DictionaryEntry.class);
        this.modelDataPreprocessings = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_MODEL_DATA_PREPROCESSING, String.class);
        this.domains = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_DOMAIN, String.class);
        this.typeOfModels = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_TYPE_OF_MODEL, String.class);
        this.standardCompliances = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_STANDARD_COMPLIANCE, String.class);
        this.modelExplainabilitys = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_MODEL_EXPLAINABILITY, String.class);
        this.getHyperparameters().addAll(builder.hyperparameters);
        this.getMetrics().addAll(builder.metrics);
        this.getMetricDecisionThresholds().addAll(builder.metricDecisionThresholds);
        this.getModelDataPreprocessings().addAll(builder.modelDataPreprocessings);
        this.getDomains().addAll(builder.domains);
        this.getTypeOfModels().addAll(builder.typeOfModels);
        this.getStandardCompliances().addAll(builder.standardCompliances);
        this.getModelExplainabilitys().addAll(builder.modelExplainabilitys);
        this.setEnergyConsumption(builder.energyConsumption);
        this.setAutonomyType(builder.autonomyType);
        this.setUseSensitivePersonalInformation(builder.useSensitivePersonalInformation);
        this.setSafetyRiskAssessment(builder.safetyRiskAssessment);
        this.setInformationAboutTraining(builder.informationAboutTraining);
        this.setLimitation(builder.limitation);
        this.setInformationAboutApplication(builder.informationAboutApplication);
    }

    @Override
    public String getType() {
        return "AI.AIPackage";
    }

    public Collection<DictionaryEntry> getHyperparameters() {
        return this.hyperparameters;
    }

    public Collection<DictionaryEntry> getMetrics() {
        return this.metrics;
    }

    public Collection<DictionaryEntry> getMetricDecisionThresholds() {
        return this.metricDecisionThresholds;
    }

    public Collection<String> getModelDataPreprocessings() {
        return this.modelDataPreprocessings;
    }

    public Collection<String> getDomains() {
        return this.domains;
    }

    public Collection<String> getTypeOfModels() {
        return this.typeOfModels;
    }

    public Collection<String> getStandardCompliances() {
        return this.standardCompliances;
    }

    public Collection<String> getModelExplainabilitys() {
        return this.modelExplainabilitys;
    }

    @Override
    public AIPackage setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    public Optional<EnergyConsumption> getEnergyConsumption() throws InvalidSPDXAnalysisException {
        Optional retval = this.getObjectPropertyValue(SpdxConstantsV3.PROP_ENERGY_CONSUMPTION);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof EnergyConsumption)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for energyConsumption");
            }
            return retval;
        }
        return Optional.empty();
    }

    public AIPackage setEnergyConsumption(@Nullable EnergyConsumption energyConsumption) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_ENERGY_CONSUMPTION, (Object)energyConsumption);
        return this;
    }

    @Override
    public AIPackage setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
        super.setSuppliedBy(suppliedBy);
        return this;
    }

    public Optional<PresenceType> getAutonomyType() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_AUTONOMY_TYPE);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof PresenceType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for autonomyType");
            }
            return retval;
        }
        return Optional.empty();
    }

    public AIPackage setAutonomyType(@Nullable PresenceType autonomyType) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_AUTONOMY_TYPE, (Object)autonomyType);
        return this;
    }

    public Optional<PresenceType> getUseSensitivePersonalInformation() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_USE_SENSITIVE_PERSONAL_INFORMATION);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof PresenceType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for useSensitivePersonalInformation");
            }
            return retval;
        }
        return Optional.empty();
    }

    public AIPackage setUseSensitivePersonalInformation(@Nullable PresenceType useSensitivePersonalInformation) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_USE_SENSITIVE_PERSONAL_INFORMATION, (Object)useSensitivePersonalInformation);
        return this;
    }

    public Optional<SafetyRiskAssessmentType> getSafetyRiskAssessment() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_SAFETY_RISK_ASSESSMENT);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof SafetyRiskAssessmentType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for safetyRiskAssessment");
            }
            return retval;
        }
        return Optional.empty();
    }

    public AIPackage setSafetyRiskAssessment(@Nullable SafetyRiskAssessmentType safetyRiskAssessment) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_SAFETY_RISK_ASSESSMENT, (Object)safetyRiskAssessment);
        return this;
    }

    @Override
    public AIPackage setPrimaryPurpose(@Nullable SoftwarePurpose primaryPurpose) throws InvalidSPDXAnalysisException {
        super.setPrimaryPurpose(primaryPurpose);
        return this;
    }

    @Override
    public AIPackage setValidUntilTime(@Nullable String validUntilTime) throws InvalidSPDXAnalysisException {
        super.setValidUntilTime(validUntilTime);
        return this;
    }

    @Override
    public AIPackage setDownloadLocation(@Nullable String downloadLocation) throws InvalidSPDXAnalysisException {
        super.setDownloadLocation(downloadLocation);
        return this;
    }

    @Override
    public AIPackage setBuiltTime(@Nullable String builtTime) throws InvalidSPDXAnalysisException {
        super.setBuiltTime(builtTime);
        return this;
    }

    @Override
    public AIPackage setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public AIPackage setPackageVersion(@Nullable String packageVersion) throws InvalidSPDXAnalysisException {
        super.setPackageVersion(packageVersion);
        return this;
    }

    @Override
    public AIPackage setReleaseTime(@Nullable String releaseTime) throws InvalidSPDXAnalysisException {
        super.setReleaseTime(releaseTime);
        return this;
    }

    @Override
    public AIPackage setCopyrightText(@Nullable String copyrightText) throws InvalidSPDXAnalysisException {
        super.setCopyrightText(copyrightText);
        return this;
    }

    public Optional<String> getInformationAboutTraining() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_INFORMATION_ABOUT_TRAINING);
    }

    public AIPackage setInformationAboutTraining(@Nullable String informationAboutTraining) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_INFORMATION_ABOUT_TRAINING, informationAboutTraining);
        return this;
    }

    @Override
    public AIPackage setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public AIPackage setHomePage(@Nullable String homePage) throws InvalidSPDXAnalysisException {
        super.setHomePage(homePage);
        return this;
    }

    @Override
    public AIPackage setSourceInfo(@Nullable String sourceInfo) throws InvalidSPDXAnalysisException {
        super.setSourceInfo(sourceInfo);
        return this;
    }

    public Optional<String> getLimitation() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_LIMITATION);
    }

    public AIPackage setLimitation(@Nullable String limitation) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_LIMITATION, limitation);
        return this;
    }

    @Override
    public AIPackage setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public AIPackage setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public AIPackage setPackageUrl(@Nullable String packageUrl) throws InvalidSPDXAnalysisException {
        super.setPackageUrl(packageUrl);
        return this;
    }

    public Optional<String> getInformationAboutApplication() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_INFORMATION_ABOUT_APPLICATION);
    }

    public AIPackage setInformationAboutApplication(@Nullable String informationAboutApplication) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_INFORMATION_ABOUT_APPLICATION, informationAboutApplication);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        Optional<Object> e2;
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Optional<EnergyConsumption> energyConsumption = this.getEnergyConsumption();
            if (energyConsumption.isPresent()) {
                retval.addAll(energyConsumption.get().verify(verifiedIds, specVersionForVerify, profiles));
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Error getting energyConsumption for AIPackage: " + e2.getMessage());
        }
        try {
            e2 = this.getAutonomyType();
        }
        catch (InvalidSPDXAnalysisException e3) {
            retval.add("Error getting autonomyType for AIPackage: " + e3.getMessage());
        }
        try {
            e2 = this.getUseSensitivePersonalInformation();
        }
        catch (InvalidSPDXAnalysisException e4) {
            retval.add("Error getting useSensitivePersonalInformation for AIPackage: " + e4.getMessage());
        }
        try {
            e2 = this.getSafetyRiskAssessment();
        }
        catch (InvalidSPDXAnalysisException e5) {
            retval.add("Error getting safetyRiskAssessment for AIPackage: " + e5.getMessage());
        }
        try {
            e2 = this.getInformationAboutTraining();
        }
        catch (InvalidSPDXAnalysisException e6) {
            retval.add("Error getting informationAboutTraining for AIPackage: " + e6.getMessage());
        }
        try {
            e2 = this.getLimitation();
        }
        catch (InvalidSPDXAnalysisException e7) {
            retval.add("Error getting limitation for AIPackage: " + e7.getMessage());
        }
        try {
            e2 = this.getInformationAboutApplication();
        }
        catch (InvalidSPDXAnalysisException e8) {
            retval.add("Error getting informationAboutApplication for AIPackage: " + e8.getMessage());
        }
        for (DictionaryEntry hyperparameter : this.hyperparameters) {
            retval.addAll(hyperparameter.verify(verifiedIds, specVersionForVerify, profiles));
        }
        for (DictionaryEntry metric : this.metrics) {
            retval.addAll(metric.verify(verifiedIds, specVersionForVerify, profiles));
        }
        for (DictionaryEntry metricDecisionThreshold : this.metricDecisionThresholds) {
            retval.addAll(metricDecisionThreshold.verify(verifiedIds, specVersionForVerify, profiles));
        }
        return retval;
    }

    public static class AIPackageBuilder
    extends SpdxPackage.SpdxPackageBuilder {
        protected Collection<DictionaryEntry> hyperparameters = new ArrayList<DictionaryEntry>();
        protected Collection<DictionaryEntry> metrics = new ArrayList<DictionaryEntry>();
        protected Collection<DictionaryEntry> metricDecisionThresholds = new ArrayList<DictionaryEntry>();
        protected Collection<String> modelDataPreprocessings = new ArrayList<String>();
        protected Collection<String> domains = new ArrayList<String>();
        protected Collection<String> typeOfModels = new ArrayList<String>();
        protected Collection<String> standardCompliances = new ArrayList<String>();
        protected Collection<String> modelExplainabilitys = new ArrayList<String>();
        protected EnergyConsumption energyConsumption = null;
        protected PresenceType autonomyType = null;
        protected PresenceType useSensitivePersonalInformation = null;
        protected SafetyRiskAssessmentType safetyRiskAssessment = null;
        protected String informationAboutTraining = null;
        protected String limitation = null;
        protected String informationAboutApplication = null;

        public AIPackageBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public AIPackageBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public AIPackageBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public AIPackageBuilder addContentIdentifier(ContentIdentifier contentIdentifier) {
            if (Objects.nonNull((Object)contentIdentifier)) {
                this.contentIdentifiers.add(contentIdentifier);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addAllContentIdentifier(Collection<ContentIdentifier> contentIdentifierCollection) {
            if (Objects.nonNull(contentIdentifierCollection)) {
                this.contentIdentifiers.addAll(contentIdentifierCollection);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        public AIPackageBuilder addHyperparameter(DictionaryEntry hyperparameter) {
            if (Objects.nonNull((Object)hyperparameter)) {
                this.hyperparameters.add(hyperparameter);
            }
            return this;
        }

        public AIPackageBuilder addAllHyperparameter(Collection<DictionaryEntry> hyperparameterCollection) {
            if (Objects.nonNull(hyperparameterCollection)) {
                this.hyperparameters.addAll(hyperparameterCollection);
            }
            return this;
        }

        public AIPackageBuilder addMetric(DictionaryEntry metric) {
            if (Objects.nonNull((Object)metric)) {
                this.metrics.add(metric);
            }
            return this;
        }

        public AIPackageBuilder addAllMetric(Collection<DictionaryEntry> metricCollection) {
            if (Objects.nonNull(metricCollection)) {
                this.metrics.addAll(metricCollection);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        public AIPackageBuilder addMetricDecisionThreshold(DictionaryEntry metricDecisionThreshold) {
            if (Objects.nonNull((Object)metricDecisionThreshold)) {
                this.metricDecisionThresholds.add(metricDecisionThreshold);
            }
            return this;
        }

        public AIPackageBuilder addAllMetricDecisionThreshold(Collection<DictionaryEntry> metricDecisionThresholdCollection) {
            if (Objects.nonNull(metricDecisionThresholdCollection)) {
                this.metricDecisionThresholds.addAll(metricDecisionThresholdCollection);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addOriginatedBy(Agent originatedBy) {
            if (Objects.nonNull((Object)originatedBy)) {
                this.originatedBys.add(originatedBy);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addAllOriginatedBy(Collection<Agent> originatedByCollection) {
            if (Objects.nonNull(originatedByCollection)) {
                this.originatedBys.addAll(originatedByCollection);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addSupportLevel(SupportType supportLevel) {
            if (Objects.nonNull((Object)supportLevel)) {
                this.supportLevels.add(supportLevel);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addAllSupportLevel(Collection<SupportType> supportLevelCollection) {
            if (Objects.nonNull(supportLevelCollection)) {
                this.supportLevels.addAll(supportLevelCollection);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addAdditionalPurpose(SoftwarePurpose additionalPurpose) {
            if (Objects.nonNull((Object)additionalPurpose)) {
                this.additionalPurposes.add(additionalPurpose);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addAllAdditionalPurpose(Collection<SoftwarePurpose> additionalPurposeCollection) {
            if (Objects.nonNull(additionalPurposeCollection)) {
                this.additionalPurposes.addAll(additionalPurposeCollection);
            }
            return this;
        }

        public AIPackageBuilder addModelDataPreprocessing(String modelDataPreprocessing) {
            if (Objects.nonNull(modelDataPreprocessing)) {
                this.modelDataPreprocessings.add(modelDataPreprocessing);
            }
            return this;
        }

        public AIPackageBuilder addAllModelDataPreprocessing(Collection<String> modelDataPreprocessingCollection) {
            if (Objects.nonNull(modelDataPreprocessingCollection)) {
                this.modelDataPreprocessings.addAll(modelDataPreprocessingCollection);
            }
            return this;
        }

        public AIPackageBuilder addDomain(String domain) {
            if (Objects.nonNull(domain)) {
                this.domains.add(domain);
            }
            return this;
        }

        public AIPackageBuilder addAllDomain(Collection<String> domainCollection) {
            if (Objects.nonNull(domainCollection)) {
                this.domains.addAll(domainCollection);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addAttributionText(String attributionText) {
            if (Objects.nonNull(attributionText)) {
                this.attributionTexts.add(attributionText);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addAllAttributionText(Collection<String> attributionTextCollection) {
            if (Objects.nonNull(attributionTextCollection)) {
                this.attributionTexts.addAll(attributionTextCollection);
            }
            return this;
        }

        public AIPackageBuilder addTypeOfModel(String typeOfModel) {
            if (Objects.nonNull(typeOfModel)) {
                this.typeOfModels.add(typeOfModel);
            }
            return this;
        }

        public AIPackageBuilder addAllTypeOfModel(Collection<String> typeOfModelCollection) {
            if (Objects.nonNull(typeOfModelCollection)) {
                this.typeOfModels.addAll(typeOfModelCollection);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addStandardName(String standardName) {
            if (Objects.nonNull(standardName)) {
                this.standardNames.add(standardName);
            }
            return this;
        }

        @Override
        public AIPackageBuilder addAllStandardName(Collection<String> standardNameCollection) {
            if (Objects.nonNull(standardNameCollection)) {
                this.standardNames.addAll(standardNameCollection);
            }
            return this;
        }

        public AIPackageBuilder addStandardCompliance(String standardCompliance) {
            if (Objects.nonNull(standardCompliance)) {
                this.standardCompliances.add(standardCompliance);
            }
            return this;
        }

        public AIPackageBuilder addAllStandardCompliance(Collection<String> standardComplianceCollection) {
            if (Objects.nonNull(standardComplianceCollection)) {
                this.standardCompliances.addAll(standardComplianceCollection);
            }
            return this;
        }

        public AIPackageBuilder addModelExplainability(String modelExplainability) {
            if (Objects.nonNull(modelExplainability)) {
                this.modelExplainabilitys.add(modelExplainability);
            }
            return this;
        }

        public AIPackageBuilder addAllModelExplainability(Collection<String> modelExplainabilityCollection) {
            if (Objects.nonNull(modelExplainabilityCollection)) {
                this.modelExplainabilitys.addAll(modelExplainabilityCollection);
            }
            return this;
        }

        @Override
        public AIPackageBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        public AIPackageBuilder setEnergyConsumption(EnergyConsumption energyConsumption) {
            this.energyConsumption = energyConsumption;
            return this;
        }

        @Override
        public AIPackageBuilder setSuppliedBy(Agent suppliedBy) {
            this.suppliedBy = suppliedBy;
            return this;
        }

        public AIPackageBuilder setAutonomyType(PresenceType autonomyType) {
            this.autonomyType = autonomyType;
            return this;
        }

        public AIPackageBuilder setUseSensitivePersonalInformation(PresenceType useSensitivePersonalInformation) {
            this.useSensitivePersonalInformation = useSensitivePersonalInformation;
            return this;
        }

        public AIPackageBuilder setSafetyRiskAssessment(SafetyRiskAssessmentType safetyRiskAssessment) {
            this.safetyRiskAssessment = safetyRiskAssessment;
            return this;
        }

        @Override
        public AIPackageBuilder setPrimaryPurpose(SoftwarePurpose primaryPurpose) {
            this.primaryPurpose = primaryPurpose;
            return this;
        }

        @Override
        public AIPackageBuilder setValidUntilTime(String validUntilTime) {
            this.validUntilTime = validUntilTime;
            return this;
        }

        @Override
        public AIPackageBuilder setDownloadLocation(String downloadLocation) {
            this.downloadLocation = downloadLocation;
            return this;
        }

        @Override
        public AIPackageBuilder setBuiltTime(String builtTime) {
            this.builtTime = builtTime;
            return this;
        }

        @Override
        public AIPackageBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public AIPackageBuilder setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        @Override
        public AIPackageBuilder setReleaseTime(String releaseTime) {
            this.releaseTime = releaseTime;
            return this;
        }

        @Override
        public AIPackageBuilder setCopyrightText(String copyrightText) {
            this.copyrightText = copyrightText;
            return this;
        }

        public AIPackageBuilder setInformationAboutTraining(String informationAboutTraining) {
            this.informationAboutTraining = informationAboutTraining;
            return this;
        }

        @Override
        public AIPackageBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public AIPackageBuilder setHomePage(String homePage) {
            this.homePage = homePage;
            return this;
        }

        @Override
        public AIPackageBuilder setSourceInfo(String sourceInfo) {
            this.sourceInfo = sourceInfo;
            return this;
        }

        public AIPackageBuilder setLimitation(String limitation) {
            this.limitation = limitation;
            return this;
        }

        @Override
        public AIPackageBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public AIPackageBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public AIPackageBuilder setPackageUrl(String packageUrl) {
            this.packageUrl = packageUrl;
            return this;
        }

        public AIPackageBuilder setInformationAboutApplication(String informationAboutApplication) {
            this.informationAboutApplication = informationAboutApplication;
            return this;
        }

        @Override
        public AIPackage build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                AIPackage aIPackage = new AIPackage(this);
                return aIPackage;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

