/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.compatv2;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.ModelRegistryException;
import org.spdx.core.SpdxInvalidIdException;
import org.spdx.core.SpdxInvalidTypeException;
import org.spdx.core.TypedValue;
import org.spdx.storage.IModelStore;
import org.spdx.storage.PropertyDescriptor;

public class CompatibleModelStoreWrapper
implements IModelStore {
    public static final String LATEST_SPDX_2X_VERSION = "SPDX-2.3";
    public static final String RDF_NAMESPACE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String RDFS_NAMESPACE = "http://www.w3.org/2000/01/rdf-schema#";
    public static final String SPDX_NAMESPACE = "http://spdx.org/rdf/terms#";
    public static final String DOAP_NAMESPACE = "http://usefulinc.com/ns/doap#";
    public static final String OWL_NAMESPACE = "http://www.w3.org/2002/07/owl#";
    public static final String RDF_POINTER_NAMESPACE = "http://www.w3.org/2009/pointers#";
    public static final String XML_SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema#";
    static final Map<String, String> PROP_NAME_TO_NON_SPDX_NS;
    private IModelStore baseStore;

    public CompatibleModelStoreWrapper(IModelStore baseStore) {
        Objects.requireNonNull(baseStore, "A base store must be provided for the CompatibleModelStoreWrapper");
        this.baseStore = baseStore;
    }

    public static PropertyDescriptor propNameToPropDescriptor(String propName) {
        return new PropertyDescriptor(propName, PROP_NAME_TO_NON_SPDX_NS.getOrDefault(propName, SPDX_NAMESPACE));
    }

    public void close() throws Exception {
        this.baseStore.close();
    }

    public boolean exists(String documentUri, String id) {
        return this.exists(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore));
    }

    public static String documentUriIdToUri(String documentUri, String id, IModelStore store) {
        return CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, store.isAnon(id));
    }

    public static String documentUriToNamespace(String documentUri) {
        if (documentUri.contains("://spdx.org/licenses/")) {
            return documentUri;
        }
        return documentUri + "#";
    }

    public static String documentUriIdToUri(String documentUri, String id, boolean anonymous) {
        return anonymous ? id : CompatibleModelStoreWrapper.documentUriToNamespace(documentUri) + id;
    }

    public static TypedValue typedValueFromDocUri(String documentUri, String id, boolean anonymous, String type) throws SpdxInvalidIdException, SpdxInvalidTypeException, ModelRegistryException {
        return new TypedValue(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, anonymous), type, LATEST_SPDX_2X_VERSION);
    }

    public static TypedValue typedValueFromDocUri(String documentUri, String id, IModelStore store, String type) throws SpdxInvalidIdException, SpdxInvalidTypeException, ModelRegistryException {
        return new TypedValue(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, store), type, LATEST_SPDX_2X_VERSION);
    }

    public static String objectUriToId(IModelStore store, String objectUri, String documentUri) throws InvalidSPDXAnalysisException {
        return CompatibleModelStoreWrapper.objectUriToId(store.isAnon(objectUri), objectUri, documentUri);
    }

    public static String objectUriToId(boolean anon, String objectUri, String documentUri) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(objectUri, "Object URI can not be null");
        if (anon) {
            return objectUri;
        }
        if (objectUri.startsWith("https://spdx.org/licenses/")) {
            return objectUri.substring("https://spdx.org/licenses/".length());
        }
        if (objectUri.startsWith("http://spdx.org/licenses/")) {
            return objectUri.substring("http://spdx.org/licenses/".length());
        }
        if ("http://spdx.org/rdf/terms#noassertion".equals(objectUri)) {
            return "NOASSERTION";
        }
        if ("http://spdx.org/rdf/terms#none".equals(objectUri)) {
            return "NONE";
        }
        Objects.requireNonNull(documentUri, "Document URI can not be null");
        String nameSpace = documentUri + "#";
        if (!objectUri.startsWith(nameSpace)) {
            throw new InvalidSPDXAnalysisException("Object URI must start with document URI + #.  DocumentUri: " + documentUri + ", Object URI: " + objectUri);
        }
        return objectUri.substring(nameSpace.length());
    }

    public boolean exists(String uri) {
        return this.baseStore.exists(uri);
    }

    public void create(String documentUri, String id, String type) throws InvalidSPDXAnalysisException {
        this.baseStore.create(new TypedValue(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this), type, LATEST_SPDX_2X_VERSION));
    }

    public void create(TypedValue typedValue) throws InvalidSPDXAnalysisException {
        this.baseStore.create(typedValue);
    }

    public List<PropertyDescriptor> getPropertyValueDescriptors(String objectUri) throws InvalidSPDXAnalysisException {
        return this.baseStore.getPropertyValueDescriptors(objectUri);
    }

    public List<PropertyDescriptor> getPropertyValueDescriptors(String documentUri, String id) throws InvalidSPDXAnalysisException {
        return this.getPropertyValueDescriptors(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore));
    }

    public Collection<String> getPropertyValueNames(String objectUri) throws InvalidSPDXAnalysisException {
        return StreamSupport.stream(this.getPropertyValueDescriptors(objectUri).spliterator(), false).map(descriptor -> descriptor.getName()).collect(Collectors.toList());
    }

    public Collection<String> getPropertyValueNames(String documentUri, String id) throws InvalidSPDXAnalysisException {
        return this.getPropertyValueNames(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore));
    }

    public void setValue(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        this.baseStore.setValue(objectUri, propertyDescriptor, value);
    }

    public void setValue(String documentUri, String id, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        this.setValue(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), propertyDescriptor, value);
    }

    public void setValue(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        this.setValue(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), CompatibleModelStoreWrapper.propNameToPropDescriptor(propertyName), value);
    }

    public Optional<Object> getValue(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        return this.baseStore.getValue(objectUri, propertyDescriptor);
    }

    public Optional<Object> getValue(String documentUri, String id, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        return this.getValue(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), propertyDescriptor);
    }

    public Optional<Object> getValue(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        return this.getValue(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), CompatibleModelStoreWrapper.propNameToPropDescriptor(propertyName));
    }

    public String getNextId(IModelStore.IdType idType, String documentUri) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "SPDX V2 requires a namespace for generating next ID's");
        return this.baseStore.getNextId(idType);
    }

    public String getNextId(IModelStore.IdType idType) throws InvalidSPDXAnalysisException {
        return this.baseStore.getNextId(idType);
    }

    public void removeProperty(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        this.baseStore.removeProperty(objectUri, propertyDescriptor);
    }

    public void removeProperty(String documentUri, String id, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        this.removeProperty(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), propertyDescriptor);
    }

    public void removeProperty(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        this.removeProperty(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), CompatibleModelStoreWrapper.propNameToPropDescriptor(propertyName));
    }

    public Stream<TypedValue> getAllItems(String nameSpace, String typeFilter) throws InvalidSPDXAnalysisException {
        return this.baseStore.getAllItems(nameSpace, typeFilter);
    }

    public IModelStore.IModelStoreLock enterCriticalSection(boolean readLockRequested) throws InvalidSPDXAnalysisException {
        return this.baseStore.enterCriticalSection(readLockRequested);
    }

    public IModelStore.IModelStoreLock enterCriticalSection(String documentUri, boolean readLockRequested) throws InvalidSPDXAnalysisException {
        return this.enterCriticalSection(readLockRequested);
    }

    public void leaveCriticalSection(IModelStore.IModelStoreLock lock) {
        this.baseStore.leaveCriticalSection(lock);
    }

    public boolean removeValueFromCollection(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        return this.baseStore.removeValueFromCollection(objectUri, propertyDescriptor, value);
    }

    public boolean removeValueFromCollection(String documentUri, String id, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        return this.removeValueFromCollection(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), propertyDescriptor, value);
    }

    public boolean removeValueFromCollection(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        return this.removeValueFromCollection(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), CompatibleModelStoreWrapper.propNameToPropDescriptor(propertyName), value);
    }

    public int collectionSize(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        return this.baseStore.collectionSize(objectUri, propertyDescriptor);
    }

    public int collectionSize(String documentUri, String id, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        return this.collectionSize(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), propertyDescriptor);
    }

    public int collectionSize(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        return this.collectionSize(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), CompatibleModelStoreWrapper.propNameToPropDescriptor(propertyName));
    }

    public boolean collectionContains(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        return this.baseStore.collectionContains(objectUri, propertyDescriptor, value);
    }

    public boolean collectionContains(String documentUri, String id, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        return this.collectionContains(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), propertyDescriptor, value);
    }

    public boolean collectionContains(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        return this.collectionContains(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), CompatibleModelStoreWrapper.propNameToPropDescriptor(propertyName), value);
    }

    public void clearValueCollection(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        this.baseStore.clearValueCollection(objectUri, propertyDescriptor);
    }

    public void clearValueCollection(String documentUri, String id, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        this.clearValueCollection(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), propertyDescriptor);
    }

    public void clearValueCollection(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        this.clearValueCollection(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), CompatibleModelStoreWrapper.propNameToPropDescriptor(propertyName));
    }

    public boolean addValueToCollection(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        return this.baseStore.addValueToCollection(objectUri, propertyDescriptor, value);
    }

    public boolean addValueToCollection(String documentUri, String id, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        return this.addValueToCollection(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), propertyDescriptor, value);
    }

    public boolean addValueToCollection(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        return this.addValueToCollection(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), CompatibleModelStoreWrapper.propNameToPropDescriptor(propertyName), value);
    }

    public Iterator<Object> listValues(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        return this.baseStore.listValues(objectUri, propertyDescriptor);
    }

    public Iterator<Object> listValues(String documentUri, String id, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        return this.listValues(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), propertyDescriptor);
    }

    public Iterator<Object> listValues(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        return this.listValues(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), CompatibleModelStoreWrapper.propNameToPropDescriptor(propertyName));
    }

    public boolean isCollectionMembersAssignableTo(String objectUri, PropertyDescriptor propertyDescriptor, Class<?> clazz) throws InvalidSPDXAnalysisException {
        return this.baseStore.isCollectionMembersAssignableTo(objectUri, propertyDescriptor, clazz);
    }

    public boolean isCollectionMembersAssignableTo(String documentUri, String id, PropertyDescriptor propertyDescriptor, Class<?> clazz) throws InvalidSPDXAnalysisException {
        return this.isCollectionMembersAssignableTo(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), propertyDescriptor, clazz);
    }

    public boolean isCollectionMembersAssignableTo(String documentUri, String id, String propertyName, Class<?> clazz) throws InvalidSPDXAnalysisException {
        return this.isCollectionMembersAssignableTo(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), CompatibleModelStoreWrapper.propNameToPropDescriptor(propertyName), clazz);
    }

    public boolean isPropertyValueAssignableTo(String objectUri, PropertyDescriptor propertyDescriptor, Class<?> clazz, String specVersion) throws InvalidSPDXAnalysisException {
        return this.baseStore.isPropertyValueAssignableTo(objectUri, propertyDescriptor, clazz, specVersion);
    }

    public boolean isPropertyValueAssignableTo(String documentUri, String id, PropertyDescriptor propertyDescriptor, Class<?> clazz) throws InvalidSPDXAnalysisException {
        return this.isPropertyValueAssignableTo(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), propertyDescriptor, clazz, LATEST_SPDX_2X_VERSION);
    }

    public boolean isPropertyValueAssignableTo(String documentUri, String id, String propertyName, Class<?> clazz) throws InvalidSPDXAnalysisException {
        return this.isPropertyValueAssignableTo(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), CompatibleModelStoreWrapper.propNameToPropDescriptor(propertyName), clazz, LATEST_SPDX_2X_VERSION);
    }

    public boolean isCollectionProperty(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        return this.baseStore.isCollectionProperty(objectUri, propertyDescriptor);
    }

    public boolean isCollectionProperty(String documentUri, String id, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        return this.isCollectionProperty(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), propertyDescriptor);
    }

    public boolean isCollectionProperty(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        return this.isCollectionProperty(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore), CompatibleModelStoreWrapper.propNameToPropDescriptor(propertyName));
    }

    public IModelStore.IdType getIdType(String objectUri) {
        return this.baseStore.getIdType(objectUri);
    }

    public Optional<String> getCaseSensitiveId(String documentUri, String caseInsensitiveId) {
        return this.baseStore.getCaseSensitiveId(documentUri, caseInsensitiveId);
    }

    public Optional<TypedValue> getTypedValue(String objectUri) throws InvalidSPDXAnalysisException {
        return this.baseStore.getTypedValue(objectUri);
    }

    public Optional<TypedValue> getTypedValue(String documentUri, String id) throws InvalidSPDXAnalysisException {
        return this.getTypedValue(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore));
    }

    public void delete(String documentUri) throws InvalidSPDXAnalysisException {
        this.baseStore.delete(documentUri);
    }

    public void delete(String documentUri, String id) throws InvalidSPDXAnalysisException {
        this.delete(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, this.baseStore));
    }

    public IModelStore getBaseModelStore() {
        return this.baseStore;
    }

    public boolean equals(Object comp) {
        return comp instanceof CompatibleModelStoreWrapper && this.getBaseModelStore().equals((Object)((CompatibleModelStoreWrapper)comp).getBaseModelStore());
    }

    public int hashCode() {
        return 0xB ^ super.hashCode();
    }

    public boolean isAnon(String objectUri) {
        return this.baseStore.isAnon(objectUri);
    }

    static {
        HashMap<String, String> nameToNS = new HashMap<String, String>();
        nameToNS.put("type", RDF_NAMESPACE);
        nameToNS.put("resource", RDF_NAMESPACE);
        nameToNS.put("sameAs", OWL_NAMESPACE);
        nameToNS.put("comment", RDFS_NAMESPACE);
        nameToNS.put("label", RDFS_NAMESPACE);
        nameToNS.put("seeAlso", RDFS_NAMESPACE);
        nameToNS.put("homepage", DOAP_NAMESPACE);
        nameToNS.put("startPointer", RDF_POINTER_NAMESPACE);
        nameToNS.put("endPointer", RDF_POINTER_NAMESPACE);
        nameToNS.put("reference", RDF_POINTER_NAMESPACE);
        nameToNS.put("offset", RDF_POINTER_NAMESPACE);
        nameToNS.put("lineNumber", RDF_POINTER_NAMESPACE);
        PROP_NAME_TO_NON_SPDX_NS = Collections.unmodifiableMap(nameToNS);
    }

    public static class TypedValueCompatV2 {
        String id;
        String type;

        public TypedValueCompatV2(String id, String type) {
            this.id = id;
            this.type = type;
        }
    }
}

