/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2.pointer;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.SpdxInvalidTypeException;
import org.spdx.library.model.v2.ModelObjectV2;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.pointer.SinglePointer;
import org.spdx.storage.IModelStore;

public abstract class CompoundPointer
extends ModelObjectV2 {
    public CompoundPointer() throws InvalidSPDXAnalysisException {
    }

    public CompoundPointer(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public CompoundPointer(IModelStore modelStore, String documentUri, String id, IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    @Nullable
    public SinglePointer getStartPointer() throws InvalidSPDXAnalysisException {
        Optional retval = this.getObjectPropertyValue(SpdxConstantsCompatV2.PROP_POINTER_START_POINTER);
        if (!retval.isPresent()) {
            return null;
        }
        if (!(retval.get() instanceof SinglePointer)) {
            throw new SpdxInvalidTypeException("Incorrect type for getEndPointer - expected SinglePointer, found " + retval.get().getClass().toString());
        }
        return (SinglePointer)retval.get();
    }

    public CompoundPointer setStartPointer(SinglePointer startPointer) throws InvalidSPDXAnalysisException {
        if (this.strict && Objects.isNull(startPointer)) {
            throw new InvalidSPDXAnalysisException("Can not set required startPointer to null");
        }
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_POINTER_START_POINTER, startPointer);
        return this;
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            SinglePointer startPointer = this.getStartPointer();
            if (startPointer == null) {
                retval.add("Missing required start pointer");
            } else {
                retval.addAll(startPointer.verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException ex) {
            retval.add("Error getting start pointer: " + ex.getMessage());
        }
        return retval;
    }

    public String getType() {
        return "CompoundPointer";
    }
}

