/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2.license;

import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.storage.IModelStore;

public abstract class SimpleLicensingInfo
extends AnyLicenseInfo {
    SimpleLicensingInfo(String id) throws InvalidSPDXAnalysisException {
        super(id);
        if (!(this instanceof IndividualUriValue) && !(this instanceof SpdxListedLicense)) {
            this.setPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_ID, id);
        }
    }

    SimpleLicensingInfo(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
        if (!(this instanceof IndividualUriValue) && !(this instanceof SpdxListedLicense)) {
            this.setPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_ID, id);
        }
    }

    public String getLicenseId() {
        return this.getId();
    }

    public String getName() throws InvalidSPDXAnalysisException {
        Optional o = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_STD_LICENSE_NAME);
        if (o.isPresent()) {
            return (String)o.get();
        }
        return "";
    }

    public void setName(String name) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_STD_LICENSE_NAME, name);
    }

    public String getComment() throws InvalidSPDXAnalysisException {
        Optional o = this.getStringPropertyValue(SpdxConstantsCompatV2.RDFS_PROP_COMMENT);
        if (o.isPresent()) {
            return (String)o.get();
        }
        return "";
    }

    public void setComment(String comment) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.RDFS_PROP_COMMENT, comment);
    }

    public Collection<String> getSeeAlso() throws InvalidSPDXAnalysisException {
        return this.getStringCollection(SpdxConstantsCompatV2.RDFS_PROP_SEE_ALSO);
    }

    public void setSeeAlso(Collection<String> seeAlsoUrl) throws InvalidSPDXAnalysisException {
        if (seeAlsoUrl == null) {
            this.clearValueCollection(SpdxConstantsCompatV2.RDFS_PROP_SEE_ALSO);
        } else {
            this.setPropertyValue(SpdxConstantsCompatV2.RDFS_PROP_SEE_ALSO, seeAlsoUrl);
        }
    }
}

