/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2.license;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.SpdxInvalidTypeException;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v2.license.SimpleLicensingInfo;
import org.spdx.storage.IModelStore;

public class OrLaterOperator
extends AnyLicenseInfo {
    public OrLaterOperator() throws InvalidSPDXAnalysisException {
    }

    public OrLaterOperator(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public OrLaterOperator(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public OrLaterOperator(SimpleLicensingInfo license) throws InvalidSPDXAnalysisException {
        super(license.getModelStore(), license.getDocumentUri(), license.getModelStore().getNextId(IModelStore.IdType.Anonymous), license.getCopyManager(), true);
        this.setLicense(license);
    }

    public SimpleLicensingInfo getLicense() throws InvalidSPDXAnalysisException {
        Optional<AnyLicenseInfo> retval = this.getAnyLicenseInfoPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_SET_MEMEBER);
        if (!retval.isPresent()) {
            throw new SpdxInvalidTypeException("Missing required license for OrLater operator");
        }
        if (!(retval.get() instanceof SimpleLicensingInfo)) {
            throw new SpdxInvalidTypeException("Expecting SimpleLicensingInfo for or operator license type.  Found " + retval.getClass().toString());
        }
        return (SimpleLicensingInfo)retval.get();
    }

    public void setLicense(SimpleLicensingInfo license) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_SET_MEMEBER, (Object)license);
    }

    @Override
    public String toString() {
        SimpleLicensingInfo license;
        try {
            license = this.getLicense();
        }
        catch (InvalidSPDXAnalysisException e) {
            return "ERROR GETTING ORLATER LICENSE";
        }
        if (license == null) {
            return "UNDEFINED OR EXCEPTION";
        }
        return license.toString() + "+";
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            SimpleLicensingInfo license = this.getLicense();
            if (license == null) {
                retval.add("Missing required license for a License Or Later operator");
            } else {
                retval.addAll(license.verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Exception getting license for OrLater: " + e.getMessage());
        }
        return retval;
    }

    public String getType() {
        return "OrLaterOperator";
    }

    @Override
    public boolean equals(Object compare) {
        if (!(compare instanceof OrLaterOperator)) {
            return false;
        }
        try {
            SimpleLicensingInfo cLic = ((OrLaterOperator)((Object)compare)).getLicense();
            return Objects.equals((Object)this.getLicense(), (Object)cLic);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int hashCode() {
        int licHashCode = 101;
        try {
            if (this.getLicense() != null) {
                licHashCode = this.getLicense().hashCode() ^ 0x65;
            }
        }
        catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
            // empty catch block
        }
        return licHashCode;
    }
}

