/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2.license;

import java.util.Collection;
import java.util.Optional;
import org.spdx.core.CoreModelObject;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.license.LicenseException;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.storage.IModelStore;

public class ListedLicenseException
extends LicenseException {
    public ListedLicenseException(IModelStore modelStore, String documentUri, String id, IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public ListedLicenseException(String id, String name, String text, Collection<String> seeAlso, String comment) throws InvalidSPDXAnalysisException {
        super(id, name, text, seeAlso, comment);
    }

    public ListedLicenseException(String id, String name, String text, String template, Collection<String> seeAlso, String comment) throws InvalidSPDXAnalysisException {
        super(id, name, text, template, seeAlso, comment);
    }

    public ListedLicenseException(String id, String name, String text) throws InvalidSPDXAnalysisException {
        super(id, name, text);
    }

    @Override
    public String getType() {
        return "ListedLicenseException";
    }

    public void setExceptionTextHtml(String exceptionTextHtml) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_EXCEPTION_TEXT_HTML, exceptionTextHtml);
    }

    public String getExceptionTextHtml() throws InvalidSPDXAnalysisException {
        Optional exceptionTextHtml = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_EXCEPTION_TEXT_HTML);
        if (exceptionTextHtml.isPresent()) {
            return (String)exceptionTextHtml.get();
        }
        Optional templateText = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_EXCEPTION_TEMPLATE);
        if (templateText.isPresent()) {
            try {
                return SpdxLicenseTemplateHelper.templateTextToHtml((String)((String)templateText.get()));
            }
            catch (LicenseTemplateRuleException ex) {
                throw new InvalidSPDXAnalysisException("Invalid license rule found in exception text for exception " + this.getName() + ":" + ex.getMessage());
            }
        }
        Optional exceptionText = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_EXCEPTION_TEXT);
        if (exceptionText.isPresent()) {
            return SpdxLicenseTemplateHelper.formatEscapeHTML((String)((String)exceptionText.get()));
        }
        return "";
    }

    public boolean equivalent(CoreModelObject compare, boolean ignoreRelatedElements) throws InvalidSPDXAnalysisException {
        if (compare instanceof ListedLicenseException) {
            return this.getId().equals(((ListedLicenseException)compare).getId());
        }
        return super.equivalent(compare, ignoreRelatedElements);
    }
}

