/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2.license;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.storage.IModelStore;

public abstract class LicenseSet
extends AnyLicenseInfo {
    Collection<AnyLicenseInfo> members = this.getObjectPropertyValueSet(SpdxConstantsCompatV2.PROP_LICENSE_SET_MEMEBER, AnyLicenseInfo.class);

    public LicenseSet() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public LicenseSet(String id) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), DefaultModelStore.getDefaultDocumentUri(), id, DefaultModelStore.getDefaultCopyManager(), true);
    }

    LicenseSet(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public void setMembers(Collection<AnyLicenseInfo> licenseInfos) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_SET_MEMEBER, licenseInfos);
    }

    public Collection<AnyLicenseInfo> getMembers() throws InvalidSPDXAnalysisException {
        return this.members;
    }

    public void addMember(AnyLicenseInfo member) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(member, "Member can not be null");
        this.members.add(member);
    }

    public void removeMember(AnyLicenseInfo member) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(member, "Member can not be null");
        this.members.remove((Object)member);
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            Iterator<AnyLicenseInfo> iter = this.getMembers().iterator();
            while (iter.hasNext()) {
                retval.addAll(iter.next().verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Exception getting license set members: " + e.getMessage());
        }
        return retval;
    }
}

