/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.SpdxIdNotFoundException;
import org.spdx.core.TypedValue;
import org.spdx.library.model.v2.Annotation;
import org.spdx.library.model.v2.Checksum;
import org.spdx.library.model.v2.ExternalDocumentRef;
import org.spdx.library.model.v2.ExternalRef;
import org.spdx.library.model.v2.ExternalSpdxElement;
import org.spdx.library.model.v2.GenericModelObject;
import org.spdx.library.model.v2.GenericSpdxElement;
import org.spdx.library.model.v2.GenericSpdxItem;
import org.spdx.library.model.v2.ModelObjectV2;
import org.spdx.library.model.v2.ReferenceType;
import org.spdx.library.model.v2.Relationship;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxCreatorInformation;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.library.model.v2.SpdxElement;
import org.spdx.library.model.v2.SpdxFile;
import org.spdx.library.model.v2.SpdxItem;
import org.spdx.library.model.v2.SpdxNoAssertionElement;
import org.spdx.library.model.v2.SpdxNoneElement;
import org.spdx.library.model.v2.SpdxPackage;
import org.spdx.library.model.v2.SpdxPackageVerificationCode;
import org.spdx.library.model.v2.SpdxSnippet;
import org.spdx.library.model.v2.enumerations.AnnotationType;
import org.spdx.library.model.v2.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.v2.enumerations.FileType;
import org.spdx.library.model.v2.enumerations.Purpose;
import org.spdx.library.model.v2.enumerations.ReferenceCategory;
import org.spdx.library.model.v2.enumerations.RelationshipType;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v2.license.ConjunctiveLicenseSet;
import org.spdx.library.model.v2.license.CrossRef;
import org.spdx.library.model.v2.license.DisjunctiveLicenseSet;
import org.spdx.library.model.v2.license.ExternalExtractedLicenseInfo;
import org.spdx.library.model.v2.license.ExtractedLicenseInfo;
import org.spdx.library.model.v2.license.License;
import org.spdx.library.model.v2.license.LicenseException;
import org.spdx.library.model.v2.license.ListedLicenseException;
import org.spdx.library.model.v2.license.OrLaterOperator;
import org.spdx.library.model.v2.license.SimpleLicensingInfo;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.library.model.v2.license.SpdxNoAssertionLicense;
import org.spdx.library.model.v2.license.SpdxNoneLicense;
import org.spdx.library.model.v2.license.WithExceptionOperator;
import org.spdx.library.model.v2.pointer.ByteOffsetPointer;
import org.spdx.library.model.v2.pointer.CompoundPointer;
import org.spdx.library.model.v2.pointer.LineCharPointer;
import org.spdx.library.model.v2.pointer.SinglePointer;
import org.spdx.library.model.v2.pointer.StartEndPointer;
import org.spdx.storage.IModelStore;
import org.spdx.storage.compatv2.CompatibleModelStoreWrapper;

public class SpdxModelFactoryCompatV2 {
    static final Logger logger = LoggerFactory.getLogger(SpdxModelFactoryCompatV2.class);
    public static Map<String, Class<?>> SPDX_TYPE_TO_CLASS_V2;
    public static Map<Class<?>, String> SPDX_CLASS_TO_TYPE;

    public static SpdxDocument createSpdxDocumentV2(IModelStore modelStore, String documentUri, IModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        SpdxDocument retval = new SpdxDocument(modelStore, documentUri, copyManager, true);
        String date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date());
        SpdxCreatorInformation creationInfo = new SpdxCreatorInformation(modelStore, documentUri, modelStore.getNextId(IModelStore.IdType.Anonymous), copyManager, true);
        creationInfo.getCreators().add("Tool: SPDX Tools");
        creationInfo.setCreated(date);
        retval.setCreationInfo(creationInfo);
        retval.setDataLicense(SpdxModelFactoryCompatV2.createSpdxDocumentDataLicense(modelStore, documentUri, copyManager));
        retval.setSpecVersion("SPDX-2.3");
        return retval;
    }

    private static AnyLicenseInfo createSpdxDocumentDataLicense(IModelStore modelStore, String documentUri, IModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        SpdxListedLicense retval = new SpdxListedLicense(modelStore, documentUri, "CC0-1.0", copyManager, true);
        retval.setFsfLibre(true);
        retval.setLicenseText("Creative Commons Legal Code\n\nCC0 1.0 Universal\n\nCREATIVE COMMONS CORPORATION IS NOT A LAW FIRM AND DOES NOT PROVIDE LEGAL SERVICES. DISTRIBUTION OF THIS DOCUMENT DOES NOT CREATE AN ATTORNEY-CLIENT RELATIONSHIP. CREATIVE COMMONS PROVIDES THIS INFORMATION ON AN \"AS-IS\" BASIS. CREATIVE COMMONS MAKES NO WARRANTIES REGARDING THE USE OF THIS DOCUMENT OR THE INFORMATION OR WORKS PROVIDED HEREUNDER, AND DISCLAIMS LIABILITY FOR DAMAGES RESULTING FROM THE USE OF THIS DOCUMENT OR THE INFORMATION OR WORKS PROVIDED HEREUNDER.\n\nStatement of Purpose\n\nThe laws of most jurisdictions throughout the world automatically confer exclusive Copyright and Related Rights (defined below) upon the creator and subsequent owner(s) (each and all, an \"owner\") of an original work of authorship and/or a database (each, a \"Work\").\n\nCertain owners wish to permanently relinquish those rights to a Work for the purpose of contributing to a commons of creative, cultural and scientific works (\"Commons\") that the public can reliably and without fear of later claims of infringement build upon, modify, incorporate in other works, reuse and redistribute as freely as possible in any form whatsoever and for any purposes, including without limitation commercial purposes. These owners may contribute to the Commons to promote the ideal of a free culture and the further production of creative, cultural and scientific works, or to gain reputation or greater distribution for their Work in part through the use and efforts of others.\n\nFor these and/or other purposes and motivations, and without any expectation of additional consideration or compensation, the person associating CC0 with a Work (the \"Affirmer\"), to the extent that he or she is an owner of Copyright and Related Rights in the Work, voluntarily elects to apply CC0 to the Work and publicly distribute the Work under its terms, with knowledge of his or her Copyright and Related Rights in the Work and the meaning and intended legal effect of CC0 on those rights.\n\n1. Copyright and Related Rights. A Work made available under CC0 may be protected by copyright and related or neighboring rights (\"Copyright and Related Rights\"). Copyright and Related Rights include, but are not limited to, the following:\ni. the right to reproduce, adapt, distribute, perform, display, communicate, and translate a Work;\nii. moral rights retained by the original author(s) and/or performer(s);\niii. publicity and privacy rights pertaining to a person's image or likeness depicted in a Work;\niv. rights protecting against unfair competition in regards to a Work, subject to the limitations in paragraph 4(a), below;\nv. rights protecting the extraction, dissemination, use and reuse of data in a Work;\nvi. database rights (such as those arising under Directive 96/9/EC of the European Parliament and of the Council of 11 March 1996 on the legal protection of databases, and under any national implementation thereof, including any amended or successor version of such directive); and\nvii. other similar, equivalent or corresponding rights throughout the world based on applicable law or treaty, and any national implementations thereof.\n2. Waiver. To the greatest extent permitted by, but not in contravention of, applicable law, Affirmer hereby overtly, fully, permanently, irrevocably and unconditionally waives, abandons, and surrenders all of Affirmer's Copyright and Related Rights and associated claims and causes of action, whether now known or unknown (including existing as well as future claims and causes of action), in the Work (i) in all territories worldwide, (ii) for the maximum duration provided by applicable law or treaty (including future time extensions), (iii) in any current or future medium and for any number of copies, and (iv) for any purpose whatsoever, including without limitation commercial, advertising or promotional purposes (the \"Waiver\"). Affirmer makes the Waiver for the benefit of each member of the public at large and to the detriment of Affirmer's heirs and successors, fully intending that such Waiver shall not be subject to revocation, rescission, cancellation, termination, or any other legal or equitable action to disrupt the quiet enjoyment of the Work by the public as contemplated by Affirmer's express Statement of Purpose.\n3. Public License Fallback. Should any part of the Waiver for any reason be judged legally invalid or ineffective under applicable law, then the Waiver shall be preserved to the maximum extent permitted taking into account Affirmer's express Statement of Purpose. In addition, to the extent the Waiver is so judged Affirmer hereby grants to each affected person a royalty-free, non transferable, non sublicensable, non exclusive, irrevocable and unconditional license to exercise Affirmer's Copyright and Related Rights in the Work (i) in all territories worldwide, (ii) for the maximum duration provided by applicable law or treaty (including future time extensions), (iii) in any current or future medium and for any number of copies, and (iv) for any purpose whatsoever, including without limitation commercial, advertising or promotional purposes (the \"License\"). The License shall be deemed effective as of the date CC0 was applied by Affirmer to the Work. Should any part of the License for any reason be judged legally invalid or ineffective under applicable law, such partial invalidity or ineffectiveness shall not invalidate the remainder of the License, and in such case Affirmer hereby affirms that he or she will not (i) exercise any of his or her remaining Copyright and Related Rights in the Work or (ii) assert any associated claims and causes of action with respect to the Work, in either case contrary to Affirmer's express Statement of Purpose.\n4. Limitations and Disclaimers.\na. No trademark or patent rights held by Affirmer are waived, abandoned, surrendered, licensed or otherwise affected by this document.\nb. Affirmer offers the Work as-is and makes no representations or warranties of any kind concerning the Work, express, implied, statutory or otherwise, including without limitation warranties of title, merchantability, fitness for a particular purpose, non infringement, or the absence of latent or other defects, accuracy, or the present or absence of errors, whether or not discoverable, all to the greatest extent permissible under applicable law.\nc. Affirmer disclaims responsibility for clearing rights of other persons that may apply to the Work or any use thereof, including without limitation any person's Copyright and Related Rights in the Work. Further, Affirmer disclaims responsibility for obtaining any necessary consents, permissions or other rights required for any use of the Work.\nd. Affirmer understands and acknowledges that Creative Commons is not a party to this document and has no duty or obligation with respect to this CC0 or use of the Work.");
        retval.setName("Creative Commons Zero v1.0 Universal");
        retval.getSeeAlso().add("https://creativecommons.org/publicdomain/zero/1.0/legalcode");
        return retval;
    }

    public static ModelObjectV2 createModelObjectV2(IModelStore modelStore, String documentUri, String id, String type, IModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(modelStore, "Model store can not be null");
        Objects.requireNonNull(documentUri, "A document URI or namespace must be supplied for all SPDX version 2 model objects");
        Objects.requireNonNull(id, "ID must not be null");
        return SpdxModelFactoryCompatV2.getModelObjectV2(modelStore, documentUri, id, type, copyManager, true);
    }

    public static ModelObjectV2 getModelObjectV2(IModelStore modelStore, String documentUri, String id, String type, IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(modelStore, "Model store can not be null");
        Objects.requireNonNull(documentUri, "A document URI or namespace must be supplied for all SPDX version 2 model objects");
        if ("SpdxDocument".equals(type)) {
            return new SpdxDocument(modelStore, documentUri, copyManager, create);
        }
        if ("ReferenceType".equals(type)) {
            throw new InvalidSPDXAnalysisException("Reference type can only be created with a type supplied.");
        }
        if ("Review".equals(type)) {
            throw new InvalidSPDXAnalysisException("Review class is no longer supported");
        }
        Objects.requireNonNull(id, "ID must not be null");
        Class<?> clazz = SPDX_TYPE_TO_CLASS_V2.get(type);
        if (Objects.isNull(clazz)) {
            throw new InvalidSPDXAnalysisException("Unknown SPDX version 2 type: " + type);
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new InvalidSPDXAnalysisException("Can not instantiate an abstract class for the SPDX version 2 type: " + type);
        }
        try {
            Constructor<?> con = clazz.getDeclaredConstructor(IModelStore.class, String.class, String.class, IModelCopyManager.class, Boolean.TYPE);
            return (ModelObjectV2)((Object)con.newInstance(modelStore, documentUri, id, copyManager, create));
        }
        catch (NoSuchMethodException e) {
            throw new InvalidSPDXAnalysisException("Could not create the model object SPDX version 2 type: " + type);
        }
        catch (SecurityException e) {
            throw new InvalidSPDXAnalysisException("Unexpected security exception for SPDX version 2 type: " + type, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new InvalidSPDXAnalysisException("Unexpected instantiation exception for SPDX version 2 type: " + type, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidSPDXAnalysisException("Unexpected illegal access exception for SPDX version 2 type: " + type, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSPDXAnalysisException("Unexpected illegal argument exception for SPDX version 2 type: " + type, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof InvalidSPDXAnalysisException) {
                throw (InvalidSPDXAnalysisException)e.getTargetException();
            }
            throw new InvalidSPDXAnalysisException("Unexpected invocation target exception for SPDX version 2 type: " + type, (Throwable)e);
        }
    }

    public static Optional<ModelObjectV2> getModelObjectV2(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(modelStore, "Model store can not be null");
        Objects.requireNonNull(documentUri, "A document URI or namespace must be supplied for all SPDX version 2 model objects");
        Objects.requireNonNull(id, "ID must not be null");
        if (id.contains(":")) {
            try {
                String externalUri = ExternalSpdxElement.externalSpdxElementIdToURI(id, modelStore, documentUri, copyManager);
                int poundIndex = externalUri.indexOf(35);
                String externalId = externalUri.substring(poundIndex + 1);
                String externalDocUri = externalUri.substring(0, poundIndex);
                return Optional.of(new ExternalSpdxElement(modelStore, externalDocUri, externalId, copyManager));
            }
            catch (InvalidSPDXAnalysisException ex) {
                logger.warn("Attempting to get a model object for an external SPDX element without an external document ref defined.  Returning empty");
                return Optional.empty();
            }
        }
        Optional tv = modelStore.getTypedValue(CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, id, modelStore.isAnon(id)));
        if (tv.isPresent()) {
            String type = ((TypedValue)tv.get()).getType();
            try {
                return Optional.of(SpdxModelFactoryCompatV2.getModelObjectV2(modelStore, documentUri, id, type, copyManager, false));
            }
            catch (SpdxIdNotFoundException ex) {
                return Optional.empty();
            }
        }
        if (SpdxConstantsCompatV2.NOASSERTION_VALUE.equals(id)) {
            return Optional.of(new SpdxNoAssertionElement(modelStore, documentUri));
        }
        if (SpdxConstantsCompatV2.NONE_VALUE.equals(id)) {
            return Optional.of(new SpdxNoneElement(modelStore, documentUri));
        }
        return Optional.empty();
    }

    public static Class<? extends Object> typeToClass(String type) throws InvalidSPDXAnalysisException {
        Class<?> retval = SPDX_TYPE_TO_CLASS_V2.get(type);
        if (Objects.isNull(retval)) {
            throw new InvalidSPDXAnalysisException("Unknown SPDX type: " + type);
        }
        return retval;
    }

    public static Class<?> classUriToClass(String classUri) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(classUri, "Missing required class URI");
        int indexOfPound = classUri.lastIndexOf(35);
        if (indexOfPound < 1) {
            throw new InvalidSPDXAnalysisException("Invalid class URI: " + classUri);
        }
        String type = classUri.substring(indexOfPound + 1);
        return SpdxModelFactoryCompatV2.typeToClass(type);
    }

    static {
        HashMap<String, Class> typeToClassV2 = new HashMap<String, Class>();
        typeToClassV2.put("SpdxDocument", SpdxDocument.class);
        typeToClassV2.put("Package", SpdxPackage.class);
        typeToClassV2.put("CreationInfo", SpdxCreatorInformation.class);
        typeToClassV2.put("Checksum", Checksum.class);
        typeToClassV2.put("AnyLicenseInfo", AnyLicenseInfo.class);
        typeToClassV2.put("SimpleLicensingInfo", SimpleLicensingInfo.class);
        typeToClassV2.put("ConjunctiveLicenseSet", ConjunctiveLicenseSet.class);
        typeToClassV2.put("DisjunctiveLicenseSet", DisjunctiveLicenseSet.class);
        typeToClassV2.put("ExtractedLicensingInfo", ExtractedLicenseInfo.class);
        typeToClassV2.put("License", License.class);
        typeToClassV2.put("ListedLicense", SpdxListedLicense.class);
        typeToClassV2.put("LicenseException", LicenseException.class);
        typeToClassV2.put("ListedLicenseException", ListedLicenseException.class);
        typeToClassV2.put("OrLaterOperator", OrLaterOperator.class);
        typeToClassV2.put("WithExceptionOperator", WithExceptionOperator.class);
        typeToClassV2.put("File", SpdxFile.class);
        typeToClassV2.put("PackageVerificationCode", SpdxPackageVerificationCode.class);
        typeToClassV2.put("Annotation", Annotation.class);
        typeToClassV2.put("Relationship", Relationship.class);
        typeToClassV2.put("SpdxItem", SpdxItem.class);
        typeToClassV2.put("SpdxElement", SpdxElement.class);
        typeToClassV2.put("SpdxNoneElement", SpdxNoneElement.class);
        typeToClassV2.put("SpdxNoAssertionElement", SpdxNoAssertionElement.class);
        typeToClassV2.put("ExternalDocumentRef", ExternalDocumentRef.class);
        typeToClassV2.put("ExternalRef", ExternalRef.class);
        typeToClassV2.put("ReferenceType", ReferenceType.class);
        typeToClassV2.put("Snippet", SpdxSnippet.class);
        typeToClassV2.put("SpdxNoAssertionLicense", SpdxNoAssertionLicense.class);
        typeToClassV2.put("SpdxNoneLicense", SpdxNoneLicense.class);
        typeToClassV2.put("GenericModelObject", GenericModelObject.class);
        typeToClassV2.put("GenericSpdxElement", GenericSpdxElement.class);
        typeToClassV2.put("GenericSpdxItem", GenericSpdxItem.class);
        typeToClassV2.put("ExternalSpdxElement", ExternalSpdxElement.class);
        typeToClassV2.put("StartEndPointer", StartEndPointer.class);
        typeToClassV2.put("ByteOffsetPointer", ByteOffsetPointer.class);
        typeToClassV2.put("LineCharPointer", LineCharPointer.class);
        typeToClassV2.put("CompoundPointer", CompoundPointer.class);
        typeToClassV2.put("SinglePointer", SinglePointer.class);
        typeToClassV2.put("CrossRef", CrossRef.class);
        typeToClassV2.put("FileType", FileType.class);
        typeToClassV2.put("AnnotationType", AnnotationType.class);
        typeToClassV2.put("ChecksumAlgorithm", ChecksumAlgorithm.class);
        typeToClassV2.put("ReferenceCategory", ReferenceCategory.class);
        typeToClassV2.put("RelationshipType", RelationshipType.class);
        typeToClassV2.put("ExternalExtractedLicenseInfo", ExternalExtractedLicenseInfo.class);
        typeToClassV2.put("Purpose", Purpose.class);
        SPDX_TYPE_TO_CLASS_V2 = Collections.unmodifiableMap(typeToClassV2);
        HashMap<Class, String> classToType = new HashMap<Class, String>();
        for (Map.Entry entry : typeToClassV2.entrySet()) {
            classToType.put((Class)entry.getValue(), (String)entry.getKey());
        }
        SPDX_CLASS_TO_TYPE = Collections.unmodifiableMap(classToType);
    }
}

