/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.DefaultStoreNotInitializedException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.ModelObjectHelper;
import org.spdx.core.SpdxInvalidTypeException;
import org.spdx.core.TypedValue;
import org.spdx.library.model.v2.Annotation;
import org.spdx.library.model.v2.Checksum;
import org.spdx.library.model.v2.ExternalDocumentRef;
import org.spdx.library.model.v2.ExternalRef;
import org.spdx.library.model.v2.ExternalSpdxElement;
import org.spdx.library.model.v2.ReferenceType;
import org.spdx.library.model.v2.Relationship;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxCreatorInformation;
import org.spdx.library.model.v2.SpdxElement;
import org.spdx.library.model.v2.SpdxFile;
import org.spdx.library.model.v2.SpdxNoAssertion;
import org.spdx.library.model.v2.SpdxNoAssertionElement;
import org.spdx.library.model.v2.SpdxNoneElement;
import org.spdx.library.model.v2.SpdxPackage;
import org.spdx.library.model.v2.SpdxPackageVerificationCode;
import org.spdx.library.model.v2.SpdxSnippet;
import org.spdx.library.model.v2.SpdxVerificationHelper;
import org.spdx.library.model.v2.enumerations.AnnotationType;
import org.spdx.library.model.v2.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.v2.enumerations.ReferenceCategory;
import org.spdx.library.model.v2.enumerations.RelationshipType;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v2.license.ConjunctiveLicenseSet;
import org.spdx.library.model.v2.license.CrossRef;
import org.spdx.library.model.v2.license.DisjunctiveLicenseSet;
import org.spdx.library.model.v2.license.ExtractedLicenseInfo;
import org.spdx.library.model.v2.license.SpdxNoAssertionLicense;
import org.spdx.library.model.v2.license.SpdxNoneLicense;
import org.spdx.library.model.v2.pointer.ByteOffsetPointer;
import org.spdx.library.model.v2.pointer.LineCharPointer;
import org.spdx.library.model.v2.pointer.SinglePointer;
import org.spdx.library.model.v2.pointer.StartEndPointer;
import org.spdx.storage.IModelStore;
import org.spdx.storage.PropertyDescriptor;
import org.spdx.storage.compatv2.CompatibleModelStoreWrapper;

public abstract class ModelObjectV2
extends CoreModelObject {
    static final Logger logger = LoggerFactory.getLogger(ModelObjectV2.class);
    public static final String LATEST_SPDX_2_VERSION = "SPDX-2.3";
    private String documentUri;
    private String id;

    public ModelObjectV2() throws InvalidSPDXAnalysisException {
        super(LATEST_SPDX_2_VERSION);
        this.updateIdAndDocumentUri();
    }

    public ModelObjectV2(String id) throws InvalidSPDXAnalysisException {
        super(CompatibleModelStoreWrapper.documentUriIdToUri(DefaultModelStore.getDefaultDocumentUri(), id, DefaultModelStore.getDefaultModelStore()), LATEST_SPDX_2_VERSION);
        this.documentUri = DefaultModelStore.getDefaultDocumentUri();
        this.idPrefix = this.documentUri + "#";
        this.id = id;
    }

    public ModelObjectV2(IModelStore modelStore, String documentUri, String identifier, @Nullable IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, CompatibleModelStoreWrapper.documentUriIdToUri(documentUri, identifier, modelStore), copyManager, create, LATEST_SPDX_2_VERSION, CompatibleModelStoreWrapper.documentUriToNamespace(documentUri));
        Objects.requireNonNull(modelStore, "Model Store can not be null");
        Objects.requireNonNull(documentUri, "Document URI can not be null");
        Objects.requireNonNull(identifier, "ID can not be null");
        if (identifier.startsWith(documentUri)) {
            logger.warn("document URI was passed in as an ID: " + identifier);
            this.id = identifier.substring(documentUri.length());
            if (this.id.startsWith("#")) {
                this.id = this.id.substring(1);
            }
        } else {
            this.id = identifier;
        }
        this.documentUri = documentUri;
    }

    public ModelObjectV2(CoreModelObject.CoreModelObjectBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder, LATEST_SPDX_2_VERSION);
        this.updateIdAndDocumentUri();
    }

    private void updateIdAndDocumentUri() throws DefaultStoreNotInitializedException {
        if (this.objectUri.contains("#")) {
            int index = this.objectUri.lastIndexOf(35);
            this.documentUri = this.objectUri.substring(0, index);
            this.id = this.objectUri.substring(index + 1);
        } else {
            this.documentUri = Objects.isNull(this.getIdPrefix()) ? this.getIdPrefix() : DefaultModelStore.getDefaultDocumentUri();
            this.id = this.objectUri;
        }
    }

    public List<String> _verify(Set<String> verifiedElementIds, String specVersion, List<IndividualUriValue> profiles) {
        return this._verify(verifiedElementIds, specVersion);
    }

    protected abstract List<String> _verify(Set<String> var1, String var2);

    public List<String> verify(Set<String> verifiedIElementds, String specVersion) {
        if (verifiedIElementds.contains(this.id)) {
            return new ArrayList<String>();
        }
        return this._verify(verifiedIElementds, specVersion);
    }

    public String getDocumentUri() {
        return this.documentUri;
    }

    public String getId() {
        return this.id;
    }

    public boolean isRelatedElement(PropertyDescriptor propertyDescriptor) {
        return SpdxConstantsCompatV2.PROP_RELATED_SPDX_ELEMENT.equals((Object)propertyDescriptor);
    }

    public Optional<AnyLicenseInfo> getAnyLicenseInfoPropertyValue(PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        Optional result = this.getObjectPropertyValue(propertyDescriptor, AnyLicenseInfo.class);
        if (!result.isPresent()) {
            return Optional.empty();
        }
        if (result.get() instanceof AnyLicenseInfo) {
            return result;
        }
        if (result.get() instanceof IndividualUriValue) {
            String uri = ((IndividualUriValue)result.get()).getIndividualURI();
            if (SpdxConstantsCompatV2.URI_VALUE_NONE.equals(uri)) {
                return Optional.of(new SpdxNoneLicense(this.modelStore, this.documentUri));
            }
            if (SpdxConstantsCompatV2.URI_VALUE_NOASSERTION.equals(uri)) {
                return Optional.of(new SpdxNoAssertionLicense(this.modelStore, this.documentUri));
            }
            logger.error("Can not convert a URI value to a license: " + uri);
            throw new SpdxInvalidTypeException("Can not convert a URI value to a license: " + uri);
        }
        logger.error("Invalid type for AnyLicenseInfo property: " + result.get().getClass().toString());
        throw new SpdxInvalidTypeException("Invalid type for AnyLicenseInfo property: " + result.get().getClass().toString());
    }

    protected Optional<SpdxElement> getElementPropertyValue(PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        Optional result = this.getObjectPropertyValue(propertyDescriptor, SpdxElement.class);
        if (!result.isPresent()) {
            return Optional.empty();
        }
        if (result.get() instanceof SpdxElement) {
            return result;
        }
        if (result.get() instanceof IndividualUriValue) {
            String uri = ((IndividualUriValue)result.get()).getIndividualURI();
            if (SpdxConstantsCompatV2.URI_VALUE_NONE.equals(uri)) {
                return Optional.of(new SpdxNoneElement(this.modelStore, this.documentUri));
            }
            if (SpdxConstantsCompatV2.URI_VALUE_NOASSERTION.equals(uri)) {
                return Optional.of(new SpdxNoAssertionElement(this.modelStore, this.documentUri));
            }
            Matcher matcher = SpdxConstantsCompatV2.EXTERNAL_SPDX_ELEMENT_URI_PATTERN.matcher(uri);
            if (!matcher.matches()) {
                logger.error("Can not convert a URI value to an SPDX element: " + uri);
                throw new SpdxInvalidTypeException("Can not convert a URI value to an SPDX element: " + uri);
            }
            return Optional.of(new ExternalSpdxElement(this.modelStore, matcher.group(1), matcher.group(2), this.copyManager, true));
        }
        logger.error("Invalid type for SpdxElement property: " + result.get().getClass().toString());
        throw new SpdxInvalidTypeException("Invalid type for SpdxElement property: " + result.get().getClass().toString());
    }

    public int hashCode() {
        if (this.id != null) {
            return this.id.toLowerCase().hashCode() ^ this.documentUri.hashCode();
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelObjectV2)) {
            return false;
        }
        ModelObjectV2 comp = (ModelObjectV2)((Object)o);
        if (this.getModelStore().isAnon(this.id)) {
            return Objects.equals(this.modelStore, comp.getModelStore()) && Objects.equals(this.id, comp.getId()) && Objects.equals(this.documentUri, comp.getDocumentUri());
        }
        return Objects.equals(this.id, comp.getId()) && Objects.equals(this.documentUri, comp.getDocumentUri());
    }

    public TypedValue toTypedValue() throws InvalidSPDXAnalysisException {
        return CompatibleModelStoreWrapper.typedValueFromDocUri(this.documentUri, this.id, this.modelStore.isAnon(this.id), this.getType());
    }

    public boolean isNoAssertion(Object value) {
        return "NOASSERTION".equals(value) || value instanceof SpdxNoAssertionLicense || value instanceof SpdxNoAssertionElement || value instanceof SpdxNoAssertion;
    }

    public Annotation createAnnotation(String annotator, AnnotationType annotationType, String date, String comment) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(annotator, "Annotator can not be null");
        Objects.requireNonNull(annotationType, "AnnotationType can not be null");
        Objects.requireNonNull(date, "Date can not be null");
        Objects.requireNonNull(comment, "Comment can not be null");
        Annotation retval = new Annotation(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous), this.copyManager, true);
        retval.setAnnotationDate(date);
        retval.setAnnotationType(annotationType);
        retval.setAnnotator(annotator);
        retval.setComment(comment);
        return retval;
    }

    public Relationship createRelationship(SpdxElement relatedElement, RelationshipType relationshipType, @Nullable String comment) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(relatedElement, "Related Element can not be null");
        Objects.requireNonNull(relationshipType, "Relationship type can not be null");
        Relationship retval = new Relationship(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous), this.copyManager, true);
        retval.setRelatedSpdxElement(relatedElement);
        retval.setRelationshipType(relationshipType);
        if (Objects.nonNull(comment)) {
            retval.setComment(comment);
        }
        return retval;
    }

    public Checksum createChecksum(ChecksumAlgorithm algorithm, String value) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(algorithm, "Algorithm can not be null");
        Objects.requireNonNull(value, "Value can not be null");
        Checksum retval = new Checksum(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous), this.copyManager, true);
        retval.setAlgorithm(algorithm);
        retval.setValue(value);
        return retval;
    }

    public SpdxPackageVerificationCode createPackageVerificationCode(String value, Collection<String> excludedFileNames) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(value, "Value can not be null");
        Objects.requireNonNull(excludedFileNames, "Excluded Files can not be null");
        SpdxPackageVerificationCode retval = new SpdxPackageVerificationCode(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous), this.copyManager, true);
        retval.setValue(value);
        retval.getExcludedFileNames().addAll(excludedFileNames);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalDocumentRef createExternalDocumentRef(String externalDocumentId, String externalDocumentUri, Checksum checksum) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(externalDocumentUri, "External document URI can not be null");
        Objects.requireNonNull(checksum, "Checksum can not be null");
        Objects.requireNonNull(externalDocumentId, "External document ID can not be null");
        if (!SpdxVerificationHelper.isValidExternalDocRef(externalDocumentId)) {
            throw new InvalidSPDXAnalysisException("Invalid external document reference ID " + externalDocumentId + ".  Must be of the format " + SpdxConstantsCompatV2.EXTERNAL_DOC_REF_PATTERN.pattern());
        }
        if (!SpdxVerificationHelper.isValidUri(externalDocumentUri)) {
            throw new InvalidSPDXAnalysisException("Invalid external document URI: " + externalDocumentUri);
        }
        IModelStore.IModelStoreLock lock = this.modelStore.enterCriticalSection(false);
        try {
            if (this.modelStore.exists(CompatibleModelStoreWrapper.documentUriIdToUri(this.getDocumentUri(), externalDocumentId, this.modelStore))) {
                ExternalDocumentRef externalDocumentRef = new ExternalDocumentRef(this.getModelStore(), this.getDocumentUri(), externalDocumentId, this.copyManager, false);
                return externalDocumentRef;
            }
            ExternalDocumentRef retval = new ExternalDocumentRef(this.getModelStore(), this.getDocumentUri(), externalDocumentId, this.copyManager, true);
            retval.setChecksum(checksum);
            retval.setSpdxDocumentNamespace(externalDocumentUri);
            ModelObjectHelper.addValueToCollection((IModelStore)this.getModelStore(), (String)CompatibleModelStoreWrapper.documentUriIdToUri(this.getDocumentUri(), "SPDXRef-DOCUMENT", false), (PropertyDescriptor)SpdxConstantsCompatV2.PROP_SPDX_EXTERNAL_DOC_REF, (Object)retval, (IModelCopyManager)this.copyManager, (String)this.idPrefix);
            ExternalDocumentRef externalDocumentRef = retval;
            return externalDocumentRef;
        }
        finally {
            this.getModelStore().leaveCriticalSection(lock);
        }
    }

    public SpdxCreatorInformation createCreationInfo(List<String> creators, String date) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(creators, "Creators can not be null");
        Objects.requireNonNull(date, "Date can not be null");
        SpdxCreatorInformation retval = new SpdxCreatorInformation(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous), this.copyManager, true);
        retval.getCreators().addAll(creators);
        retval.setCreated(date);
        return retval;
    }

    public ExternalRef createExternalRef(ReferenceCategory category, ReferenceType referenceType, String locator, @Nullable String comment) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(category, "Category can not be null");
        Objects.requireNonNull(referenceType, "Reference type can not be null");
        Objects.requireNonNull(locator, "Locator can not be null");
        ExternalRef retval = new ExternalRef(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous), this.copyManager, true);
        retval.setReferenceCategory(category);
        retval.setReferenceType(referenceType);
        retval.setReferenceLocator(locator);
        retval.setComment(comment);
        return retval;
    }

    public SpdxFile.SpdxFileBuilder createSpdxFile(String id, String name, AnyLicenseInfo concludedLicense, Collection<AnyLicenseInfo> seenLicense, String copyrightText, Checksum sha1) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "ID can not be null");
        Objects.requireNonNull(name, "Name can not be null");
        Objects.requireNonNull(sha1, "Sha1 can not be null");
        return new SpdxFile.SpdxFileBuilder(this.modelStore, this.documentUri, id, this.copyManager, name, concludedLicense, seenLicense, copyrightText, sha1);
    }

    public SpdxPackage.SpdxPackageBuilder createPackage(String id, String name, AnyLicenseInfo concludedLicense, String copyrightText, AnyLicenseInfo licenseDeclared) {
        Objects.requireNonNull(id, "ID can not be null");
        Objects.requireNonNull(name, "Name can not be null");
        return new SpdxPackage.SpdxPackageBuilder(this.modelStore, this.documentUri, id, this.copyManager, name, concludedLicense, copyrightText, licenseDeclared);
    }

    public ByteOffsetPointer createByteOffsetPointer(SpdxElement referencedElement, int offset) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(referencedElement, "Referenced element can not be null");
        ByteOffsetPointer retval = new ByteOffsetPointer(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous), this.copyManager, true);
        retval.setReference(referencedElement);
        retval.setOffset(offset);
        return retval;
    }

    public LineCharPointer createLineCharPointer(SpdxElement referencedElement, int lineNumber) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(referencedElement, "Referenced element can not be null");
        LineCharPointer retval = new LineCharPointer(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous), this.copyManager, true);
        retval.setReference(referencedElement);
        retval.setLineNumber(lineNumber);
        return retval;
    }

    public StartEndPointer createStartEndPointer(SinglePointer startPointer, SinglePointer endPointer) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(startPointer, "Start pointer can not be null");
        Objects.requireNonNull(endPointer, "End pointer can not be null");
        StartEndPointer retval = new StartEndPointer(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous), this.copyManager, true);
        retval.setStartPointer(startPointer);
        retval.setEndPointer(endPointer);
        return retval;
    }

    public SpdxSnippet.SpdxSnippetBuilder createSpdxSnippet(String id, String name, AnyLicenseInfo concludedLicense, Collection<AnyLicenseInfo> seenLicense, String copyrightText, SpdxFile snippetFromFile, int startByte, int endByte) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "ID can not be null");
        Objects.requireNonNull(name, "Name can not be null");
        return new SpdxSnippet.SpdxSnippetBuilder(this.modelStore, this.documentUri, id, this.copyManager, name, concludedLicense, seenLicense, copyrightText, snippetFromFile, startByte, endByte);
    }

    public ConjunctiveLicenseSet createConjunctiveLicenseSet(Collection<AnyLicenseInfo> members) throws InvalidSPDXAnalysisException {
        ConjunctiveLicenseSet retval = new ConjunctiveLicenseSet(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous), this.copyManager, true);
        retval.setMembers(members);
        return retval;
    }

    public DisjunctiveLicenseSet createDisjunctiveLicenseSet(Collection<AnyLicenseInfo> members) throws InvalidSPDXAnalysisException {
        DisjunctiveLicenseSet retval = new DisjunctiveLicenseSet(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous), this.copyManager, true);
        retval.setMembers(members);
        return retval;
    }

    public CrossRef.CrossRefBuilder createCrossRef(String url) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(url, "URL can not be null");
        return new CrossRef.CrossRefBuilder(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous), this.copyManager, url);
    }

    public ExtractedLicenseInfo createExtractedLicense(String id, String text) throws InvalidSPDXAnalysisException {
        ExtractedLicenseInfo eli = new ExtractedLicenseInfo(this.modelStore, this.documentUri, id, this.copyManager, true);
        eli.setExtractedText(text);
        return eli;
    }

    public String toString() {
        return this.getType() + " " + this.id;
    }

    protected boolean isEquivalentToNull(Object propertyValue, PropertyDescriptor descriptor) {
        if (super.isEquivalentToNull(propertyValue, descriptor)) {
            return true;
        }
        if (!SpdxConstantsCompatV2.PROP_PACKAGE_FILES_ANALYZED.equals((Object)descriptor)) {
            return false;
        }
        Object value = propertyValue instanceof Optional ? ((Optional)propertyValue).get() : propertyValue;
        return value instanceof Boolean && (Boolean)value == true;
    }
}

