/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.SpdxInvalidTypeException;
import org.spdx.library.model.v2.ModelObjectV2;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxVerificationHelper;
import org.spdx.library.model.v2.enumerations.ChecksumAlgorithm;
import org.spdx.storage.IModelStore;

public class Checksum
extends ModelObjectV2
implements Comparable<Checksum> {
    public Checksum() throws InvalidSPDXAnalysisException {
    }

    public Checksum(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public Checksum(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public static Checksum create(IModelStore modelStore, String documentUri, ChecksumAlgorithm algorithm, String value) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(modelStore, "Missing required model store");
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(algorithm, "Missing required algorithm");
        Objects.requireNonNull(value, "Missing required value");
        Checksum retval = new Checksum(modelStore, documentUri, modelStore.getNextId(IModelStore.IdType.Anonymous), null, true);
        retval.setAlgorithm(algorithm);
        retval.setValue(value);
        return retval;
    }

    public String getType() {
        return "Checksum";
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval;
        block8: {
            retval = new ArrayList<String>();
            try {
                ChecksumAlgorithm algorithm = this.getAlgorithm();
                if (ChecksumAlgorithm.MISSING.equals((Object)algorithm)) {
                    retval.add("Missing required algorithm");
                    break block8;
                }
                try {
                    String checksumValue = this.getValue();
                    if (checksumValue.isEmpty()) {
                        retval.add("Missing required checksum value");
                    } else {
                        String verify = SpdxVerificationHelper.verifyChecksumString(checksumValue, algorithm, specVersion);
                        if (verify != null) {
                            retval.add(verify);
                        }
                    }
                }
                catch (InvalidSPDXAnalysisException e) {
                    logger.error("Error getting checksum value", (Throwable)e);
                    retval.add("Error getting checksum value: " + e.getMessage());
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Error getting algorithm", (Throwable)e);
                retval.add("Error getting checksum algorithm: " + e.getMessage());
            }
        }
        return retval;
    }

    public ChecksumAlgorithm getAlgorithm() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsCompatV2.PROP_CHECKSUM_ALGORITHM);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof ChecksumAlgorithm)) {
                logger.error("Invalid type for checksum algorithm: " + retval.get().getClass().toString());
                throw new SpdxInvalidTypeException("Invalid type for checksum algorithm: " + retval.get().getClass().toString());
            }
            return (ChecksumAlgorithm)((Object)retval.get());
        }
        return ChecksumAlgorithm.MISSING;
    }

    public void setAlgorithm(ChecksumAlgorithm algorithm) throws InvalidSPDXAnalysisException {
        if (this.strict && Objects.isNull((Object)algorithm)) {
            throw new InvalidSPDXAnalysisException("Can not set required checksum algorithm to null");
        }
        if (ChecksumAlgorithm.MISSING.equals((Object)algorithm)) {
            throw new InvalidSPDXAnalysisException("Can not set required checksum algorithm to MISSING.  This is only used when no algorithm value was found.");
        }
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_CHECKSUM_ALGORITHM, (Object)algorithm);
    }

    public String getValue() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_CHECKSUM_VALUE);
        if (retval.isPresent()) {
            return (String)retval.get();
        }
        return "";
    }

    public void setValue(String value) throws InvalidSPDXAnalysisException {
        if (this.strict) {
            String verify;
            if (Objects.isNull(value)) {
                throw new InvalidSPDXAnalysisException("Can not set required checksum value to null");
            }
            ChecksumAlgorithm algorithm = this.getAlgorithm();
            if (!ChecksumAlgorithm.MISSING.equals((Object)algorithm) && (verify = SpdxVerificationHelper.verifyChecksumString(value, algorithm, this.specVersion)) != null && !verify.isEmpty()) {
                throw new InvalidSPDXAnalysisException(verify);
            }
        }
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_CHECKSUM_VALUE, value);
    }

    @Override
    public String toString() {
        String checksumValue;
        ChecksumAlgorithm algorithm;
        try {
            algorithm = this.getAlgorithm();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting algorithm", (Throwable)e);
            algorithm = ChecksumAlgorithm.MISSING;
        }
        try {
            checksumValue = this.getValue();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting value", (Throwable)e);
            checksumValue = "";
        }
        if (ChecksumAlgorithm.MISSING.equals((Object)algorithm) || checksumValue.isEmpty()) {
            return "[EMPTY-CHECKSUM]";
        }
        return algorithm.toString() + " " + checksumValue;
    }

    @Override
    public int compareTo(Checksum compare) {
        String compareChecksumValue;
        ChecksumAlgorithm compareAlgorithm;
        String checksumValue;
        ChecksumAlgorithm algorithm;
        try {
            algorithm = this.getAlgorithm();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting algorithm", (Throwable)e);
            algorithm = ChecksumAlgorithm.MISSING;
        }
        try {
            checksumValue = this.getValue();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting value", (Throwable)e);
            checksumValue = "";
        }
        try {
            compareAlgorithm = compare.getAlgorithm();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting compare algorithm", (Throwable)e);
            compareAlgorithm = ChecksumAlgorithm.MISSING;
        }
        try {
            compareChecksumValue = compare.getValue();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting compare value", (Throwable)e);
            compareChecksumValue = "";
        }
        int retval = algorithm.toString().compareTo(compareAlgorithm.toString());
        if (retval == 0) {
            retval = checksumValue.compareTo(compareChecksumValue);
        }
        return retval;
    }
}

