/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pickle.objects;

import java.io.Serializable;

public class ComplexNumber
implements Serializable {
    private static final long serialVersionUID = 7093033866379803297L;
    private double r;
    private double i;

    public ComplexNumber(double d, double d2) {
        this.r = d;
        this.i = d2;
    }

    public ComplexNumber(Double d, Double d2) {
        this.r = d;
        this.i = d2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append(this.r);
        if (this.i >= 0.0) {
            stringBuffer.append('+');
        }
        return stringBuffer.append(this.i).append('i').toString();
    }

    public double getReal() {
        return this.r;
    }

    public double getImaginary() {
        return this.i;
    }

    public double magnitude() {
        return Math.sqrt(this.r * this.r + this.i * this.i);
    }

    public ComplexNumber add(ComplexNumber complexNumber) {
        return ComplexNumber.add(this, complexNumber);
    }

    public static ComplexNumber add(ComplexNumber complexNumber, ComplexNumber complexNumber2) {
        return new ComplexNumber(complexNumber.r + complexNumber2.r, complexNumber.i + complexNumber2.i);
    }

    public ComplexNumber subtract(ComplexNumber complexNumber) {
        return ComplexNumber.subtract(this, complexNumber);
    }

    public static ComplexNumber subtract(ComplexNumber complexNumber, ComplexNumber complexNumber2) {
        return new ComplexNumber(complexNumber.r - complexNumber2.r, complexNumber.i - complexNumber2.i);
    }

    public ComplexNumber multiply(ComplexNumber complexNumber) {
        return ComplexNumber.multiply(this, complexNumber);
    }

    public static ComplexNumber multiply(ComplexNumber complexNumber, ComplexNumber complexNumber2) {
        return new ComplexNumber(complexNumber.r * complexNumber2.r - complexNumber.i * complexNumber2.i, complexNumber.r * complexNumber2.i + complexNumber.i * complexNumber2.r);
    }

    public static ComplexNumber divide(ComplexNumber complexNumber, ComplexNumber complexNumber2) {
        return new ComplexNumber((complexNumber.r * complexNumber2.r + complexNumber.i * complexNumber2.i) / (complexNumber2.r * complexNumber2.r + complexNumber2.i * complexNumber2.i), (complexNumber.i * complexNumber2.r - complexNumber.r * complexNumber2.i) / (complexNumber2.r * complexNumber2.r + complexNumber2.i * complexNumber2.i));
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComplexNumber)) {
            return false;
        }
        ComplexNumber complexNumber = (ComplexNumber)object;
        return this.r == complexNumber.r && this.i == complexNumber.i;
    }

    public int hashCode() {
        return new Double(this.r).hashCode() ^ new Double(this.i).hashCode();
    }
}

