/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pickle;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.InvalidOpcodeException;
import net.razorvine.pickle.PickleException;
import net.razorvine.pickle.PickleUtils;
import net.razorvine.pickle.PythonException;
import net.razorvine.pickle.UnpickleStack;
import net.razorvine.pickle.objects.AnyClassConstructor;
import net.razorvine.pickle.objects.ArrayConstructor;
import net.razorvine.pickle.objects.ByteArrayConstructor;
import net.razorvine.pickle.objects.ClassDictConstructor;
import net.razorvine.pickle.objects.ComplexNumber;
import net.razorvine.pickle.objects.DateTimeConstructor;
import net.razorvine.pickle.objects.SetConstructor;

public class Unpickler {
    private final int HIGHEST_PROTOCOL = 3;
    private Map<Integer, Object> memo = new HashMap<Integer, Object>();
    private UnpickleStack stack;
    private InputStream input;
    private static Map<String, IObjectConstructor> objectConstructors = new HashMap<String, IObjectConstructor>();

    public static void registerConstructor(String string, String string2, IObjectConstructor iObjectConstructor) {
        objectConstructors.put(string + "." + string2, iObjectConstructor);
    }

    public Object load(InputStream inputStream) throws PickleException, IOException {
        this.stack = new UnpickleStack();
        this.input = inputStream;
        try {
            while (true) {
                short s;
                if ((s = PickleUtils.readbyte(this.input)) == -1) {
                    throw new IOException("premature end of file");
                }
                this.dispatch(s);
            }
        }
        catch (StopException stopException) {
            return stopException.value;
        }
    }

    public Object loads(byte[] byArray) throws PickleException, IOException {
        return this.load(new ByteArrayInputStream(byArray));
    }

    public void close() {
        if (this.stack != null) {
            this.stack.clear();
        }
        if (this.memo != null) {
            this.memo.clear();
        }
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void dispatch(short s) throws PickleException, IOException {
        switch (s) {
            case 40: {
                this.load_mark();
                break;
            }
            case 46: {
                Object object = this.stack.pop();
                this.stack.clear();
                throw new StopException(object);
            }
            case 48: {
                this.load_pop();
                break;
            }
            case 49: {
                this.load_pop_mark();
                break;
            }
            case 50: {
                this.load_dup();
                break;
            }
            case 70: {
                this.load_float();
                break;
            }
            case 73: {
                this.load_int();
                break;
            }
            case 74: {
                this.load_binint();
                break;
            }
            case 75: {
                this.load_binint1();
                break;
            }
            case 76: {
                this.load_long();
                break;
            }
            case 77: {
                this.load_binint2();
                break;
            }
            case 78: {
                this.load_none();
                break;
            }
            case 80: {
                throw new InvalidOpcodeException("opcode not implemented: PERSID");
            }
            case 81: {
                throw new InvalidOpcodeException("opcode not implemented: BINPERSID");
            }
            case 82: {
                this.load_reduce();
                break;
            }
            case 83: {
                this.load_string();
                break;
            }
            case 84: {
                this.load_binstring();
                break;
            }
            case 85: {
                this.load_short_binstring();
                break;
            }
            case 86: {
                this.load_unicode();
                break;
            }
            case 88: {
                this.load_binunicode();
                break;
            }
            case 97: {
                this.load_append();
                break;
            }
            case 98: {
                this.load_build();
                break;
            }
            case 99: {
                this.load_global();
                break;
            }
            case 100: {
                this.load_dict();
                break;
            }
            case 125: {
                this.load_empty_dictionary();
                break;
            }
            case 101: {
                this.load_appends();
                break;
            }
            case 103: {
                this.load_get();
                break;
            }
            case 104: {
                this.load_binget();
                break;
            }
            case 105: {
                throw new InvalidOpcodeException("opcode not implemented: INST");
            }
            case 106: {
                this.load_long_binget();
                break;
            }
            case 108: {
                this.load_list();
                break;
            }
            case 93: {
                this.load_empty_list();
                break;
            }
            case 111: {
                throw new InvalidOpcodeException("opcode not implemented: OBJ");
            }
            case 112: {
                this.load_put();
                break;
            }
            case 113: {
                this.load_binput();
                break;
            }
            case 114: {
                this.load_long_binput();
                break;
            }
            case 115: {
                this.load_setitem();
                break;
            }
            case 116: {
                this.load_tuple();
                break;
            }
            case 41: {
                this.load_empty_tuple();
                break;
            }
            case 117: {
                this.load_setitems();
                break;
            }
            case 71: {
                this.load_binfloat();
                break;
            }
            case 128: {
                this.load_proto();
                break;
            }
            case 129: {
                this.load_newobj();
                break;
            }
            case 130: {
                throw new InvalidOpcodeException("opcode not implemented: EXT1");
            }
            case 131: {
                throw new InvalidOpcodeException("opcode not implemented: EXT2");
            }
            case 132: {
                throw new InvalidOpcodeException("opcode not implemented: EXT4");
            }
            case 133: {
                this.load_tuple1();
                break;
            }
            case 134: {
                this.load_tuple2();
                break;
            }
            case 135: {
                this.load_tuple3();
                break;
            }
            case 136: {
                this.load_true();
                break;
            }
            case 137: {
                this.load_false();
                break;
            }
            case 138: {
                this.load_long1();
                break;
            }
            case 139: {
                this.load_long4();
                break;
            }
            case 66: {
                this.load_binbytes();
                break;
            }
            case 67: {
                this.load_short_binbytes();
                break;
            }
            default: {
                throw new InvalidOpcodeException("invalid pickle opcode: " + s);
            }
        }
    }

    void load_build() {
        Object object = this.stack.pop();
        Object object2 = this.stack.peek();
        try {
            Method method = object2.getClass().getMethod("__setstate__", object.getClass());
            method.invoke(object2, object);
        }
        catch (Exception exception) {
            throw new PickleException("failed to __setstate__()", exception);
        }
    }

    void load_proto() throws IOException {
        short s = PickleUtils.readbyte(this.input);
        if (s < 0 || s > 3) {
            throw new PickleException("unsupported pickle protocol: " + s);
        }
    }

    void load_none() {
        this.stack.add(null);
    }

    void load_false() {
        this.stack.add(false);
    }

    void load_true() {
        this.stack.add(true);
    }

    void load_int() throws IOException {
        Comparable<Boolean> comparable;
        String string = PickleUtils.readline(this.input, true);
        if (string.equals("I00\n".substring(1))) {
            comparable = false;
        } else if (string.equals("I01\n".substring(1))) {
            comparable = true;
        } else {
            String string2 = string.substring(0, string.length() - 1);
            try {
                comparable = Integer.parseInt(string2, 10);
            }
            catch (NumberFormatException numberFormatException) {
                comparable = Long.parseLong(string2, 10);
            }
        }
        this.stack.add(comparable);
    }

    void load_binint() throws IOException {
        int n = PickleUtils.bytes_to_integer(PickleUtils.readbytes(this.input, 4));
        this.stack.add(n);
    }

    void load_binint1() throws IOException {
        this.stack.add(PickleUtils.readbyte(this.input));
    }

    void load_binint2() throws IOException {
        int n = PickleUtils.bytes_to_integer(PickleUtils.readbytes(this.input, 2));
        this.stack.add(n);
    }

    void load_long() throws IOException {
        String string = PickleUtils.readline(this.input);
        if (string != null && string.endsWith("L")) {
            string = string.substring(0, string.length() - 1);
        }
        BigInteger bigInteger = new BigInteger(string);
        this.stack.add(PickleUtils.optimizeBigint(bigInteger));
    }

    void load_long1() throws IOException {
        short s = PickleUtils.readbyte(this.input);
        byte[] byArray = PickleUtils.readbytes(this.input, s);
        this.stack.add(PickleUtils.decode_long(byArray));
    }

    void load_long4() throws IOException {
        int n = PickleUtils.bytes_to_integer(PickleUtils.readbytes(this.input, 4));
        byte[] byArray = PickleUtils.readbytes(this.input, n);
        this.stack.add(PickleUtils.decode_long(byArray));
    }

    void load_float() throws IOException {
        String string = PickleUtils.readline(this.input, true);
        this.stack.add(Double.parseDouble(string));
    }

    void load_binfloat() throws IOException {
        double d = PickleUtils.bytes_to_double(PickleUtils.readbytes(this.input, 8), 0);
        this.stack.add(d);
    }

    void load_string() throws IOException {
        String string = PickleUtils.readline(this.input);
        boolean bl = false;
        for (String string2 : new String[]{"\"", "'"}) {
            if (!string.startsWith(string2)) continue;
            if (!string.endsWith(string2)) {
                throw new PickleException("insecure string pickle");
            }
            string = string.substring(1, string.length() - 1);
            bl = true;
            break;
        }
        if (!bl) {
            throw new PickleException("insecure string pickle");
        }
        this.stack.add(PickleUtils.decode_escaped(string));
    }

    void load_binstring() throws IOException {
        int n = PickleUtils.bytes_to_integer(PickleUtils.readbytes(this.input, 4));
        byte[] byArray = PickleUtils.readbytes(this.input, n);
        this.stack.add(PickleUtils.rawStringFromBytes(byArray));
    }

    void load_binbytes() throws IOException {
        int n = PickleUtils.bytes_to_integer(PickleUtils.readbytes(this.input, 4));
        this.stack.add(PickleUtils.readbytes(this.input, n));
    }

    void load_unicode() throws IOException {
        String string = PickleUtils.decode_unicode_escaped(PickleUtils.readline(this.input));
        this.stack.add(string);
    }

    void load_binunicode() throws IOException {
        int n = PickleUtils.bytes_to_integer(PickleUtils.readbytes(this.input, 4));
        byte[] byArray = PickleUtils.readbytes(this.input, n);
        this.stack.add(new String(byArray, "UTF-8"));
    }

    void load_short_binstring() throws IOException {
        short s = PickleUtils.readbyte(this.input);
        byte[] byArray = PickleUtils.readbytes(this.input, s);
        this.stack.add(PickleUtils.rawStringFromBytes(byArray));
    }

    void load_short_binbytes() throws IOException {
        short s = PickleUtils.readbyte(this.input);
        this.stack.add(PickleUtils.readbytes(this.input, s));
    }

    void load_tuple() {
        ArrayList<Object> arrayList = this.stack.pop_all_since_marker();
        this.stack.add(arrayList.toArray());
    }

    void load_empty_tuple() {
        this.stack.add(new Object[0]);
    }

    void load_tuple1() {
        this.stack.add(new Object[]{this.stack.pop()});
    }

    void load_tuple2() {
        Object object = this.stack.pop();
        Object object2 = this.stack.pop();
        this.stack.add(new Object[]{object2, object});
    }

    void load_tuple3() {
        Object object = this.stack.pop();
        Object object2 = this.stack.pop();
        Object object3 = this.stack.pop();
        this.stack.add(new Object[]{object3, object2, object});
    }

    void load_empty_list() {
        this.stack.add(new ArrayList(0));
    }

    void load_empty_dictionary() {
        this.stack.add(new HashMap(0));
    }

    void load_list() {
        ArrayList<Object> arrayList = this.stack.pop_all_since_marker();
        this.stack.add(arrayList);
    }

    void load_dict() {
        ArrayList<Object> arrayList = this.stack.pop_all_since_marker();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(arrayList.size());
        for (int i = 0; i < arrayList.size(); i += 2) {
            Object object = arrayList.get(i);
            Object object2 = arrayList.get(i + 1);
            hashMap.put(object, object2);
        }
        this.stack.add(hashMap);
    }

    void load_global() throws IOException {
        String string = PickleUtils.readline(this.input);
        String string2 = PickleUtils.readline(this.input);
        IObjectConstructor iObjectConstructor = objectConstructors.get(string + "." + string2);
        if (iObjectConstructor == null) {
            iObjectConstructor = string.equals("exceptions") ? new AnyClassConstructor(PythonException.class) : (string.equals("builtins") || string.equals("__builtin__") ? (string2.endsWith("Error") || string2.endsWith("Warning") || string2.endsWith("Exception") || string2.equals("GeneratorExit") || string2.equals("KeyboardInterrupt") || string2.equals("StopIteration") || string2.equals("SystemExit") ? new AnyClassConstructor(PythonException.class) : new ClassDictConstructor(string, string2)) : new ClassDictConstructor(string, string2));
        }
        this.stack.add(iObjectConstructor);
    }

    void load_pop() {
        this.stack.pop();
    }

    void load_pop_mark() {
        Object object = null;
        while ((object = this.stack.pop()) != this.stack.MARKER) {
        }
        this.stack.trim();
    }

    void load_dup() {
        this.stack.add(this.stack.peek());
    }

    void load_get() throws IOException {
        int n = Integer.parseInt(PickleUtils.readline(this.input), 10);
        if (!this.memo.containsKey(n)) {
            throw new PickleException("invalid memo key");
        }
        this.stack.add(this.memo.get(n));
    }

    void load_binget() throws IOException {
        short s = PickleUtils.readbyte(this.input);
        if (!this.memo.containsKey(s)) {
            throw new PickleException("invalid memo key");
        }
        this.stack.add(this.memo.get(s));
    }

    void load_long_binget() throws IOException {
        int n = PickleUtils.bytes_to_integer(PickleUtils.readbytes(this.input, 4));
        if (!this.memo.containsKey(n)) {
            throw new PickleException("invalid memo key");
        }
        this.stack.add(this.memo.get(n));
    }

    void load_put() throws IOException {
        int n = Integer.parseInt(PickleUtils.readline(this.input), 10);
        this.memo.put(n, this.stack.peek());
    }

    void load_binput() throws IOException {
        short s = PickleUtils.readbyte(this.input);
        this.memo.put(Integer.valueOf(s), this.stack.peek());
    }

    void load_long_binput() throws IOException {
        int n = PickleUtils.bytes_to_integer(PickleUtils.readbytes(this.input, 4));
        this.memo.put(n, this.stack.peek());
    }

    void load_append() {
        Object object = this.stack.pop();
        ArrayList arrayList = (ArrayList)this.stack.peek();
        arrayList.add(object);
    }

    void load_appends() {
        ArrayList<Object> arrayList = this.stack.pop_all_since_marker();
        ArrayList arrayList2 = (ArrayList)this.stack.peek();
        arrayList2.addAll(arrayList);
        arrayList2.trimToSize();
    }

    void load_setitem() {
        Object object = this.stack.pop();
        Object object2 = this.stack.pop();
        Map map = (Map)this.stack.peek();
        map.put(object2, object);
    }

    void load_setitems() {
        Object object;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Object object2 = this.stack.pop();
        while (object2 != this.stack.MARKER) {
            object = this.stack.pop();
            hashMap.put(object, object2);
            object2 = this.stack.pop();
        }
        object = (Map)this.stack.peek();
        object.putAll(hashMap);
    }

    void load_mark() {
        this.stack.add_mark();
    }

    void load_reduce() {
        Object[] objectArray = (Object[])this.stack.pop();
        IObjectConstructor iObjectConstructor = (IObjectConstructor)this.stack.pop();
        this.stack.add(iObjectConstructor.construct(objectArray));
    }

    void load_newobj() {
        this.load_reduce();
    }

    static {
        objectConstructors.put("__builtin__.complex", new AnyClassConstructor(ComplexNumber.class));
        objectConstructors.put("builtins.complex", new AnyClassConstructor(ComplexNumber.class));
        objectConstructors.put("array.array", new ArrayConstructor());
        objectConstructors.put("array._array_reconstructor", new ArrayConstructor());
        objectConstructors.put("__builtin__.bytearray", new ByteArrayConstructor());
        objectConstructors.put("builtins.bytearray", new ByteArrayConstructor());
        objectConstructors.put("__builtin__.bytes", new ByteArrayConstructor());
        objectConstructors.put("__builtin__.set", new SetConstructor());
        objectConstructors.put("builtins.set", new SetConstructor());
        objectConstructors.put("datetime.datetime", new DateTimeConstructor(DateTimeConstructor.DATETIME));
        objectConstructors.put("datetime.time", new DateTimeConstructor(DateTimeConstructor.TIME));
        objectConstructors.put("datetime.date", new DateTimeConstructor(DateTimeConstructor.DATE));
        objectConstructors.put("datetime.timedelta", new DateTimeConstructor(DateTimeConstructor.TIMEDELTA));
        objectConstructors.put("decimal.Decimal", new AnyClassConstructor(BigDecimal.class));
    }

    private class StopException
    extends RuntimeException {
        private static final long serialVersionUID = 6528222454688362873L;
        public Object value;

        public StopException(Object object) {
            this.value = object;
        }
    }
}

