/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;

public abstract class InstanceCache<SeedObject, Instance> {
    private static final Log LOG = LogFactory.getLog(InstanceCache.class);
    HashMap<Integer, Instance> cache = new HashMap();

    public Instance retrieve(SeedObject hv) throws AvroSerdeException {
        return this.retrieve(hv, null);
    }

    public Instance retrieve(SeedObject hv, Set<SeedObject> seenSchemas) throws AvroSerdeException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking for hv: " + hv.toString()));
        }
        if (this.cache.containsKey(hv.hashCode())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Returning cache result.");
            }
            return this.cache.get(hv.hashCode());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Creating new instance and storing in cache");
        }
        Instance instance = this.makeInstance(hv, seenSchemas);
        this.cache.put(hv.hashCode(), instance);
        return instance;
    }

    protected abstract Instance makeInstance(SeedObject var1, Set<SeedObject> var2) throws AvroSerdeException;
}

