/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.avro;

import java.io.IOException;
import java.rmi.server.UID;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class AvroGenericRecordReader
implements RecordReader<NullWritable, AvroGenericRecordWritable>,
JobConfigurable {
    private static final Log LOG = LogFactory.getLog(AvroGenericRecordReader.class);
    private final FileReader<GenericRecord> reader;
    private final long start;
    private final long stop;
    protected JobConf jobConf;
    private final UID recordReaderID;

    public AvroGenericRecordReader(JobConf job, FileSplit split, Reporter reporter) throws IOException {
        Schema latest;
        this.jobConf = job;
        try {
            latest = this.getSchema(job, split);
        }
        catch (AvroSerdeException e) {
            throw new IOException(e);
        }
        GenericDatumReader gdr = new GenericDatumReader();
        if (latest != null) {
            gdr.setExpected(latest);
        }
        this.reader = new DataFileReader((SeekableInput)new FsInput(split.getPath(), (Configuration)job), (DatumReader)gdr);
        this.reader.sync(split.getStart());
        this.start = this.reader.tell();
        this.stop = split.getStart() + split.getLength();
        this.recordReaderID = new UID();
    }

    private Schema getSchema(JobConf job, FileSplit split) throws AvroSerdeException, IOException {
        String s;
        if (AvroSerdeUtils.insideMRJob(job)) {
            MapWork mapWork = Utilities.getMapWork((Configuration)job);
            for (Map.Entry<String, PartitionDesc> pathsAndParts : mapWork.getPathToPartitionInfo().entrySet()) {
                Properties props;
                String partitionPath = pathsAndParts.getKey();
                if (!this.pathIsInPartition(split.getPath(), partitionPath)) continue;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Matching partition " + partitionPath + " with input split " + split));
                }
                if ((props = pathsAndParts.getValue().getProperties()).containsKey("avro.schema.literal") || props.containsKey("avro.schema.url")) {
                    return AvroSerdeUtils.determineSchemaOrThrowException((Configuration)job, props);
                }
                return null;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Unable to match filesplit " + split + " with a partition."));
            }
        }
        if ((s = job.get(AvroSerdeUtils.AVRO_SERDE_SCHEMA)) != null) {
            LOG.info((Object)("Found the avro schema in the job: " + s));
            return AvroSerdeUtils.getSchemaFor(s);
        }
        return null;
    }

    private boolean pathIsInPartition(Path split, String partitionPath) {
        boolean schemeless;
        boolean bl = schemeless = split.toUri().getScheme() == null;
        if (schemeless) {
            String schemelessPartitionPath = new Path(partitionPath).toUri().getPath();
            return split.toString().startsWith(schemelessPartitionPath);
        }
        return split.toString().startsWith(partitionPath);
    }

    public boolean next(NullWritable nullWritable, AvroGenericRecordWritable record) throws IOException {
        if (!this.reader.hasNext() || this.reader.pastSync(this.stop)) {
            return false;
        }
        GenericData.Record r = (GenericData.Record)this.reader.next();
        record.setRecord((GenericRecord)r);
        record.setRecordReaderID(this.recordReaderID);
        record.setFileSchema(this.reader.getSchema());
        return true;
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public AvroGenericRecordWritable createValue() {
        return new AvroGenericRecordWritable();
    }

    public long getPos() throws IOException {
        return this.reader.tell();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public float getProgress() throws IOException {
        return this.stop == this.start ? 0.0f : Math.min(1.0f, (float)(this.getPos() - this.start) / (float)(this.stop - this.start));
    }

    public void configure(JobConf jobConf) {
        this.jobConf = jobConf;
    }
}

