/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.http.HttpClient;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import javax.annotation.Nullable;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.exception.GenericKeyStoreException;
import nl.altindag.ssl.util.KeyStoreUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.internal.http.HttpConfig;
import org.sonarsource.scanner.lib.internal.http.ssl.CertificateStore;
import org.sonarsource.scanner.lib.internal.http.ssl.SslConfig;

public class HttpClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientFactory.class);
    static final CookieManager COOKIE_MANAGER = new CookieManager();
    public static final String BC_IGNORE_USELESS_PASSWD = "org.bouncycastle.pkcs12.ignore_useless_passwd";

    private HttpClientFactory() {
    }

    static HttpClient create(HttpConfig httpConfig) {
        SocketAddress proxyAddress;
        SSLFactory sslContext = HttpClientFactory.configureSsl(httpConfig.getSslConfig(), httpConfig.skipSystemTruststore());
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder().connectTimeout(httpConfig.getConnectTimeout()).cookieHandler(COOKIE_MANAGER).sslContext(sslContext.getSslContext()).sslParameters(sslContext.getSslParameters()).followRedirects(HttpClient.Redirect.NEVER);
        if (httpConfig.getProxy() != null && (proxyAddress = httpConfig.getProxy().address()) instanceof InetSocketAddress) {
            httpClientBuilder.proxy(ProxySelector.of((InetSocketAddress)proxyAddress));
        }
        return httpClientBuilder.build();
    }

    private static SSLFactory configureSsl(SslConfig sslConfig, boolean skipSystemTrustMaterial) {
        CertificateStore trustStoreConfig;
        CertificateStore keyStoreConfig;
        SSLFactory.Builder sslFactoryBuilder = SSLFactory.builder().withDefaultTrustMaterial();
        if (!skipSystemTrustMaterial) {
            LOG.debug("Loading OS trusted SSL certificates...");
            LOG.debug("This operation might be slow or even get stuck. You can skip it by passing the scanner property '{}=true'", (Object)"sonar.scanner.skipSystemTruststore");
            sslFactoryBuilder.withSystemTrustMaterial();
        }
        if ((keyStoreConfig = sslConfig.getKeyStore()) != null) {
            keyStoreConfig.getKeyStorePassword().ifPresentOrElse(password -> sslFactoryBuilder.withIdentityMaterial(keyStoreConfig.getPath(), password.toCharArray(), keyStoreConfig.getKeyStoreType()), () -> HttpClientFactory.loadIdentityMaterialWithDefaultPassword(sslFactoryBuilder, keyStoreConfig.getPath()));
        }
        if ((trustStoreConfig = sslConfig.getTrustStore()) != null) {
            KeyStore trustStore;
            try {
                trustStore = HttpClientFactory.loadTrustStoreWithBouncyCastle(trustStoreConfig.getPath(), trustStoreConfig.getKeyStorePassword().orElse(null), trustStoreConfig.getKeyStoreType(), trustStoreConfig.isFromJvm());
                LOG.debug("Loaded truststore from '{}' containing {} certificates", (Object)trustStoreConfig.getPath(), (Object)trustStore.size());
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException("Unable to read truststore from '" + String.valueOf(trustStoreConfig.getPath()) + "'", (Throwable)e);
            }
            sslFactoryBuilder.withTrustMaterial(trustStore);
        }
        return sslFactoryBuilder.build();
    }

    private static void loadIdentityMaterialWithDefaultPassword(SSLFactory.Builder sslFactoryBuilder, Path path) {
        try {
            KeyStore keystore = KeyStoreUtils.loadKeyStore((Path)path, (char[])"changeit".toCharArray(), (String)"PKCS12");
            sslFactoryBuilder.withIdentityMaterial(keystore, "changeit".toCharArray());
        }
        catch (GenericKeyStoreException e) {
            KeyStore keystore = KeyStoreUtils.loadKeyStore((Path)path, (char[])"sonar".toCharArray(), (String)"PKCS12");
            LOG.warn("Using deprecated default password for keystore '{}'.", (Object)path);
            sslFactoryBuilder.withIdentityMaterial(keystore, "sonar".toCharArray());
        }
    }

    static KeyStore loadTrustStoreWithBouncyCastle(Path keystorePath, @Nullable String keystorePassword, String keystoreType, boolean fromJvm) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        KeyStore keystore;
        block4: {
            Properties.setThreadOverride((String)BC_IGNORE_USELESS_PASSWD, (boolean)true);
            keystore = KeyStore.getInstance(keystoreType, (Provider)new BouncyCastleProvider());
            if (keystorePassword != null) {
                HttpClientFactory.loadKeyStoreWithPassword(keystorePath, keystore, keystorePassword);
            } else {
                try {
                    HttpClientFactory.loadKeyStoreWithPassword(keystorePath, keystore, "changeit");
                }
                catch (Exception e) {
                    if (fromJvm) break block4;
                    HttpClientFactory.loadKeyStoreWithPassword(keystorePath, keystore, "sonar");
                    LOG.warn("Using deprecated default password for truststore '{}'.", (Object)keystorePath);
                }
            }
        }
        return keystore;
    }

    private static void loadKeyStoreWithPassword(Path keystorePath, KeyStore keystore, String oldDefaultPassword) throws IOException, NoSuchAlgorithmException, CertificateException {
        try (InputStream keystoreInputStream = Files.newInputStream(keystorePath, StandardOpenOption.READ);){
            keystore.load(keystoreInputStream, oldDefaultPassword.toCharArray());
        }
    }

    static {
        COOKIE_MANAGER.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
    }
}

