/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.facade.inprocess;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.internal.cache.CachedFile;
import org.sonarsource.scanner.lib.internal.cache.FileCache;
import org.sonarsource.scanner.lib.internal.facade.inprocess.BootstrapIndexDownloader;
import org.sonarsource.scanner.lib.internal.facade.inprocess.JarExtractor;
import org.sonarsource.scanner.lib.internal.http.ScannerHttpClient;

class LegacyScannerEngineDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyScannerEngineDownloader.class);
    private final FileCache fileCache;
    private final JarExtractor jarExtractor;
    private final ScannerFileDownloader scannerFileDownloader;
    private final BootstrapIndexDownloader bootstrapIndexDownloader;

    LegacyScannerEngineDownloader(ScannerFileDownloader scannerFileDownloader, BootstrapIndexDownloader bootstrapIndexDownloader, FileCache fileCache, JarExtractor jarExtractor) {
        this.scannerFileDownloader = scannerFileDownloader;
        this.bootstrapIndexDownloader = bootstrapIndexDownloader;
        this.fileCache = fileCache;
        this.jarExtractor = jarExtractor;
    }

    List<CachedFile> getOrDownload() {
        ArrayList<CachedFile> files = new ArrayList<CachedFile>();
        LOG.debug("Extract sonar-scanner-java-library-batch in temp...");
        files.add(new CachedFile(this.jarExtractor.extractToTemp("sonar-scanner-java-library-batch"), true));
        files.addAll(this.getOrDownloadScannerEngineFiles());
        return files;
    }

    private List<CachedFile> getOrDownloadScannerEngineFiles() {
        Collection<BootstrapIndexDownloader.JarEntry> index = this.bootstrapIndexDownloader.getIndex();
        return index.stream().map(jar -> this.fileCache.getOrDownload(jar.getFilename(), jar.getHash(), "MD5", this.scannerFileDownloader)).collect(Collectors.toList());
    }

    static class ScannerFileDownloader
    implements FileCache.Downloader {
        private final ScannerHttpClient connection;

        ScannerFileDownloader(ScannerHttpClient conn) {
            this.connection = conn;
        }

        @Override
        public void download(String filename, Path toFile) throws IOException {
            this.connection.downloadFromWebApi(String.format("/batch/file?name=%s", filename), toFile);
        }
    }
}

