/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.io.File;
import java.util.Optional;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.sonarqube.gradle.JavaCompilerConfiguration;

class ToolchainUtils {
    private ToolchainUtils() {
    }

    static Optional<File> getJdkHome(JavaCompile compileTask) {
        Property javaCompiler = compileTask.getJavaCompiler();
        if (javaCompiler.isPresent()) {
            return Optional.of(((JavaCompiler)javaCompiler.get()).getMetadata().getInstallationPath().getAsFile());
        }
        return Optional.empty();
    }

    public static boolean hasToolchains(JavaCompile compileTask) {
        return compileTask.getJavaCompiler().isPresent();
    }

    static void configureCompatibilityOptions(JavaCompile compileTask, JavaCompilerConfiguration config) {
        JavaInstallationMetadata toolchain = (JavaInstallationMetadata)compileTask.getJavaCompiler().map(JavaCompiler::getMetadata).getOrNull();
        if (toolchain != null) {
            Property release = compileTask.getOptions().getRelease();
            if (release.isPresent()) {
                config.setRelease(((Integer)release.get()).toString());
            } else {
                boolean isSourceOrTargetConfigured = false;
                if (compileTask.getSourceCompatibility() != null) {
                    config.setSource(compileTask.getSourceCompatibility());
                    isSourceOrTargetConfigured = true;
                }
                if (compileTask.getTargetCompatibility() != null) {
                    config.setTarget(compileTask.getTargetCompatibility());
                    isSourceOrTargetConfigured = true;
                }
                if (!isSourceOrTargetConfigured) {
                    JavaLanguageVersion languageVersion = toolchain.getLanguageVersion();
                    if (languageVersion.canCompileOrRun(10)) {
                        config.setRelease(languageVersion.toString());
                    } else {
                        String version = languageVersion.toString();
                        config.setSource(version);
                        config.setTarget(version);
                    }
                }
            }
        }
    }
}

