/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import com.android.build.gradle.api.BaseVariant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPlugin;
import org.sonarqube.gradle.ActionBroadcast;
import org.sonarqube.gradle.AndroidUtils;
import org.sonarqube.gradle.SonarPropertyComputer;
import org.sonarqube.gradle.SonarQubeExtension;
import org.sonarqube.gradle.SonarQubeProperties;
import org.sonarqube.gradle.SonarQubeTask;
import org.sonarqube.gradle.SonarUtils;

public class SonarQubePlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(SonarQubePlugin.class);
    private static final Map<Project, ActionBroadcast<SonarQubeProperties>> actionBroadcastMap = new HashMap<Project, ActionBroadcast<SonarQubeProperties>>();

    private ActionBroadcast<SonarQubeProperties> addBroadcaster(Project project) {
        ActionBroadcast<SonarQubeProperties> actionBroadcast = new ActionBroadcast<SonarQubeProperties>();
        actionBroadcastMap.put(project, actionBroadcast);
        return actionBroadcast;
    }

    private static boolean addTaskByName(Project p, String name, List<Task> allCompileTasks) {
        try {
            allCompileTasks.add(p.getTasks().getByName(name));
            return true;
        }
        catch (UnknownTaskException e) {
            return false;
        }
    }

    public void apply(Project project) {
        if (project.getExtensions().findByName("sonarqube") == null) {
            this.addExtensions(project);
            LOGGER.debug("Adding sonarqube task to " + project);
            SonarQubeTask sonarQubeTask = (SonarQubeTask)project.getTasks().create("sonarqube", SonarQubeTask.class);
            sonarQubeTask.setDescription("Analyzes " + project + " and its subprojects with SonarQube.");
            this.configureTask(sonarQubeTask, project);
        }
    }

    private void addExtensions(Project project) {
        project.allprojects(p -> {
            LOGGER.debug("Adding sonarqube extension to " + p);
            ActionBroadcast<SonarQubeProperties> actionBroadcast = this.addBroadcaster((Project)p);
            p.getExtensions().create("sonarqube", SonarQubeExtension.class, new Object[]{actionBroadcast});
        });
    }

    private void configureTask(SonarQubeTask sonarQubeTask, Project project) {
        ConventionMapping conventionMapping = sonarQubeTask.getConventionMapping();
        conventionMapping.map("properties", () -> new SonarPropertyComputer(actionBroadcastMap, project).computeSonarProperties());
        Callable<Iterable> testTasks = () -> project.getAllprojects().stream().filter(p -> p.getPlugins().hasPlugin(JavaPlugin.class) && !((SonarQubeExtension)p.getExtensions().getByType(SonarQubeExtension.class)).isSkipProject()).map(p -> p.getTasks().getByName("test")).collect(Collectors.toList());
        sonarQubeTask.dependsOn(new Object[]{testTasks});
        Callable<Iterable> compileTasks = () -> project.getAllprojects().stream().filter(p -> SonarUtils.isAndroidProject(p) && !((SonarQubeExtension)p.getExtensions().getByType(SonarQubeExtension.class)).isSkipProject()).map(p -> {
            BaseVariant variant = AndroidUtils.findVariant(p, ((SonarQubeExtension)p.getExtensions().getByType(SonarQubeExtension.class)).getAndroidVariant());
            ArrayList<Task> allCompileTasks = new ArrayList<Task>();
            boolean unitTestTaskDepAdded = SonarQubePlugin.addTaskByName(p, "compile" + SonarUtils.capitalize(variant.getName()) + "UnitTestJavaWithJavac", allCompileTasks);
            boolean androidTestTaskDepAdded = SonarQubePlugin.addTaskByName(p, "compile" + SonarUtils.capitalize(variant.getName()) + "AndroidTestJavaWithJavac", allCompileTasks);
            if (!unitTestTaskDepAdded && !androidTestTaskDepAdded) {
                SonarQubePlugin.addTaskByName(p, "compile" + SonarUtils.capitalize(variant.getName()) + "JavaWithJavac", allCompileTasks);
            }
            return allCompileTasks;
        }).flatMap(Collection::stream).collect(Collectors.toList());
        sonarQubeTask.dependsOn(new Object[]{compileTasks});
    }
}

