/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.smooks.support.StreamUtils;
import org.smooks.xml.HTMLEntityLookup;
import org.smooks.xml.LocalDTDEntityResolver;
import org.smooks.xml.LocalXSDEntityResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XmlUtils {
    public static final char[] LT = new char[]{'&', 'l', 't', ';'};
    public static final char[] GT = new char[]{'&', 'g', 't', ';'};
    public static final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
    public static final char[] QUOT = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    public static final char[] APOS = new char[]{'&', 'a', 'p', 'o', 's', ';'};
    private static final String COMMENT_START = "<!--";
    private static final String COMMENT_END = "-->";
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String ELEMENT_NAME_FUNC = "/name()";
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();

    private XmlUtils() {
    }

    public static void removeEntities(Reader reader, Writer writer) throws IOException {
        int curChar;
        if (reader == null) {
            throw new IllegalArgumentException("null reader arg");
        }
        if (writer == null) {
            throw new IllegalArgumentException("null writer arg");
        }
        StringBuffer ent = new StringBuffer(50);
        while ((curChar = reader.read()) != -1) {
            if (curChar == 38) {
                if (ent.length() > 0) {
                    writer.write(ent.toString());
                    ent.setLength(0);
                }
                ent.append((char)curChar);
                continue;
            }
            if (curChar == 59 && ent.length() > 0) {
                block21: {
                    int entLen = ent.length();
                    if (entLen > 1) {
                        if (ent.charAt(1) == '#') {
                            if (entLen > 2) {
                                char char2 = ent.charAt(2);
                                try {
                                    if (char2 == 'x' || char2 == 'X') {
                                        if (entLen > 3) {
                                            writer.write(Integer.parseInt(ent.substring(3), 16));
                                        } else {
                                            writer.write(ent.toString());
                                            writer.write(curChar);
                                        }
                                        break block21;
                                    }
                                    writer.write(Integer.parseInt(ent.substring(2)));
                                }
                                catch (NumberFormatException nfe) {
                                    writer.write(ent.toString());
                                    writer.write(curChar);
                                }
                            } else {
                                writer.write("&#;");
                            }
                        } else {
                            Character character = HTMLEntityLookup.getCharacterCode(ent.substring(1));
                            if (character != null) {
                                writer.write(character.charValue());
                            } else {
                                writer.write(ent.toString());
                                writer.write(curChar);
                            }
                        }
                    } else {
                        writer.write("&;");
                    }
                }
                ent.setLength(0);
                continue;
            }
            if (ent.length() > 0) {
                ent.append((char)curChar);
                continue;
            }
            writer.write(curChar);
        }
        if (ent.length() > 0) {
            writer.write(ent.toString());
        }
    }

    public static String removeEntities(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null string arg");
        }
        try {
            StringReader reader = new StringReader(string);
            StringWriter writer = new StringWriter();
            XmlUtils.removeEntities(reader, writer);
            return writer.toString();
        }
        catch (Exception excep) {
            excep.printStackTrace();
            return string;
        }
    }

    public static void rewriteEntities(Reader reader, Writer writer) throws IOException {
        int curChar;
        if (reader == null) {
            throw new IllegalArgumentException("null reader arg");
        }
        if (writer == null) {
            throw new IllegalArgumentException("null writer arg");
        }
        StringBuffer ent = new StringBuffer(50);
        char[] entBuf = new char[50];
        while ((curChar = reader.read()) != -1) {
            if (curChar == 38) {
                if (ent.length() > 0) {
                    writer.write(ent.toString());
                    ent.setLength(0);
                }
                ent.append((char)curChar);
                continue;
            }
            if (curChar == 59 && ent.length() > 0) {
                int entLen = ent.length();
                if (entLen > 1) {
                    if (ent.charAt(1) == '#') {
                        ent.getChars(0, ent.length(), entBuf, 0);
                        writer.write(entBuf, 0, ent.length());
                        writer.write(59);
                    } else {
                        Character character = HTMLEntityLookup.getCharacterCode(ent.substring(1));
                        if (character != null) {
                            writer.write("&#");
                            writer.write(String.valueOf((int)character.charValue()));
                            writer.write(";");
                        } else {
                            writer.write(ent.toString());
                            writer.write(curChar);
                        }
                    }
                } else {
                    writer.write("&;");
                }
                ent.setLength(0);
                continue;
            }
            if (ent.length() > 0) {
                ent.append((char)curChar);
                continue;
            }
            writer.write(curChar);
        }
        if (ent.length() > 0) {
            writer.write(ent.toString());
        }
    }

    public static Document parseStream(InputStream stream, VALIDATION_TYPE validation, boolean expandEntityRefs) throws SAXException, IOException {
        return XmlUtils.parseStream(stream, (EntityResolver)new LocalDTDEntityResolver(), validation, expandEntityRefs);
    }

    public static Document parseStream(InputStream stream, EntityResolver entityResolver, VALIDATION_TYPE validation, boolean expandEntityRefs) throws SAXException, IOException {
        return XmlUtils.parseStream(new InputStreamReader(stream), entityResolver, validation, expandEntityRefs);
    }

    public static Document parseStream(Reader stream, EntityResolver entityResolver, VALIDATION_TYPE validation, boolean expandEntityRefs) throws SAXException, IOException {
        if (stream == null) {
            throw new IllegalArgumentException("null 'stream' arg in method call.");
        }
        try {
            String streamData = StreamUtils.readStream(stream);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            if (validation == VALIDATION_TYPE.DTD) {
                factory.setValidating(true);
            } else if (validation == VALIDATION_TYPE.XSD) {
                try {
                    Schema schema = XmlUtils.getSchema(entityResolver);
                    schema.newValidator().validate(new StreamSource(new StringReader(streamData)));
                }
                catch (IllegalArgumentException e) {
                    throw new SAXException("Unable to validate document.  Installed parser '" + factory.getClass().getName() + "' doesn't support JAXP 1.2", e);
                }
            }
            factory.setExpandEntityReferences(expandEntityRefs);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            if (validation == VALIDATION_TYPE.DTD) {
                docBuilder.setEntityResolver(entityResolver);
            }
            docBuilder.setErrorHandler(XMLParseErrorHandler.getInstance());
            return docBuilder.parse(new InputSource(new StringReader(streamData)));
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to parse XML stream - XML Parser not configured correctly.", e);
        }
        catch (FactoryConfigurationError e) {
            throw new IllegalStateException("Unable to parse XML stream - DocumentBuilderFactory not configured correctly.", e);
        }
    }

    public static Document parseStream(InputStream stream) throws ParserConfigurationException, IOException, SAXException {
        return XmlUtils.parseStream(new InputStreamReader(stream));
    }

    public static Document parseStream(Reader stream) throws ParserConfigurationException, IOException, SAXException {
        return XmlUtils.parseStream(stream, null);
    }

    public static Document parseStream(Reader stream, ErrorHandler errorHandler) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        if (errorHandler != null) {
            documentBuilder.setErrorHandler(errorHandler);
        }
        return documentBuilder.parse(new InputSource(stream));
    }

    private static Schema getSchema(EntityResolver entityResolver) throws SAXException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (entityResolver instanceof LocalXSDEntityResolver) {
            return schemaFactory.newSchema(((LocalXSDEntityResolver)entityResolver).getSchemaSources());
        }
        return schemaFactory.newSchema(new StreamSource(entityResolver.resolveEntity("default", "default").getByteStream()));
    }

    public static NodeList getNodeList(Node node, String xpath) {
        if (node == null) {
            throw new IllegalArgumentException("null 'document' arg in method call.");
        }
        if (xpath == null) {
            throw new IllegalArgumentException("null 'xpath' arg in method call.");
        }
        try {
            XPath xpathEvaluater = XPATH_FACTORY.newXPath();
            if (xpath.endsWith(ELEMENT_NAME_FUNC)) {
                return (NodeList)xpathEvaluater.evaluate(xpath.substring(0, xpath.length() - ELEMENT_NAME_FUNC.length()), node, XPathConstants.NODESET);
            }
            return (NodeList)xpathEvaluater.evaluate(xpath, node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("bad 'xpath' expression [" + xpath + "].");
        }
    }

    public static Node getNode(Node node, String xpath) {
        NodeList nodeList = XmlUtils.getNodeList(node, xpath);
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0);
    }

    public static String getString(Node node, String xpath) {
        NodeList nodeList = XmlUtils.getNodeList(node, xpath);
        if (nodeList == null || nodeList.getLength() == 0) {
            return "";
        }
        if (xpath.endsWith(ELEMENT_NAME_FUNC)) {
            if (nodeList.getLength() > 0) {
                return nodeList.item(0).getNodeName();
            }
            return "";
        }
        return XmlUtils.serialize(nodeList, false);
    }

    public static String serialize(Node node) throws DOMException {
        return XmlUtils.serialize(node, false, false);
    }

    public static String serialize(NodeList nodeList, boolean closeEmptyElements) throws DOMException {
        return XmlUtils.serialize(nodeList, false, closeEmptyElements);
    }

    public static String serialize(Node node, boolean format, boolean closeEmptyElements) throws DOMException {
        StringWriter writer = new StringWriter();
        XmlUtils.serialize(node, format, (Writer)writer, closeEmptyElements);
        return writer.toString();
    }

    public static void serialize(final Node node, boolean format, Writer writer, boolean closeEmptyElements) throws DOMException {
        if (node.getNodeType() == 9) {
            XmlUtils.serialize(node.getChildNodes(), format, writer, closeEmptyElements);
        } else {
            XmlUtils.serialize(new NodeList(){

                @Override
                public Node item(int index) {
                    return node;
                }

                @Override
                public int getLength() {
                    return 1;
                }
            }, format, writer, closeEmptyElements);
        }
    }

    public static String serialize(NodeList nodeList, boolean format, boolean closeEmptyElements) throws DOMException {
        StringWriter writer = new StringWriter();
        XmlUtils.serialize(nodeList, format, (Writer)writer, closeEmptyElements);
        return writer.toString();
    }

    public static void serialize(NodeList nodeList, boolean format, Writer writer, boolean closeEmptyElements) throws DOMException {
        if (nodeList == null) {
            throw new IllegalArgumentException("null 'subtree' NodeIterator arg in method call.");
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            if (format) {
                try {
                    transformerFactory.setAttribute("indent-number", 4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            if (!closeEmptyElements) {
                transformer.setOutputProperty("method", "html");
            }
            if (format) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
            }
            int listLength = nodeList.getLength();
            for (int i = 0; i < listLength; ++i) {
                Node node = nodeList.item(i);
                if (XmlUtils.isTextNode(node)) {
                    writer.write(node.getNodeValue());
                    continue;
                }
                if (node.getNodeType() == 2) {
                    writer.write(((Attr)node).getValue());
                    continue;
                }
                if (node.getNodeType() != 1) continue;
                transformer.transform(new DOMSource(node), new StreamResult(writer));
            }
        }
        catch (Exception e) {
            DOMException domExcep = new DOMException(15, "Unable to serailise DOM subtree.");
            domExcep.initCause(e);
            throw domExcep;
        }
    }

    public static String indent(String xml, int indent) {
        StringBuilder indentedXml = new StringBuilder();
        int xmlLen = xml.length();
        char[] indentChars = new char[indent];
        Arrays.fill(indentChars, ' ');
        int i = 0;
        block0: while (i < xmlLen) {
            if (XmlUtils.isStartOf(xml, i, COMMENT_START)) {
                int commentEnd = xml.indexOf(COMMENT_END, i);
                indentedXml.append(xml, i, commentEnd);
                i = commentEnd;
                continue;
            }
            if (XmlUtils.isStartOf(xml, i, CDATA_START)) {
                int cdataEnd = xml.indexOf(CDATA_END, i);
                indentedXml.append(xml, i, cdataEnd);
                i = cdataEnd;
                continue;
            }
            char nextChar = xml.charAt(i);
            indentedXml.append(nextChar);
            if (nextChar == '\n') {
                while (true) {
                    char preXmlChar;
                    if (!Character.isWhitespace(preXmlChar = xml.charAt(++i))) {
                        if (preXmlChar != '<' || XmlUtils.isStartOf(xml, i, COMMENT_START) || XmlUtils.isStartOf(xml, i, CDATA_START)) continue block0;
                        indentedXml.append(indentChars);
                        continue block0;
                    }
                    indentedXml.append(preXmlChar);
                }
            }
            ++i;
        }
        return indentedXml.toString();
    }

    private static boolean isStartOf(String xml, int i, String substring) {
        return xml.regionMatches(i, substring, 0, substring.length());
    }

    public static boolean isTextNode(Node node) {
        if (node == null) {
            return false;
        }
        short nodeType = node.getNodeType();
        return nodeType == 4 || nodeType == 3;
    }

    public static void encodeTextValue(char[] characters, int offset, int length, Writer writer) throws IOException {
        block5: for (int i = offset; i < offset + length; ++i) {
            char c = characters[i];
            switch (c) {
                case '<': {
                    writer.write(LT, 0, LT.length);
                    continue block5;
                }
                case '>': {
                    writer.write(GT, 0, GT.length);
                    continue block5;
                }
                case '&': {
                    writer.write(AMP, 0, AMP.length);
                    continue block5;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }

    public static void encodeAttributeValue(char[] characters, int offset, int length, Writer writer) throws IOException {
        block7: for (int i = offset; i < offset + length; ++i) {
            char c = characters[i];
            switch (c) {
                case '<': {
                    writer.write(LT, 0, LT.length);
                    continue block7;
                }
                case '>': {
                    writer.write(GT, 0, GT.length);
                    continue block7;
                }
                case '&': {
                    writer.write(AMP, 0, AMP.length);
                    continue block7;
                }
                case '\'': {
                    writer.write(APOS, 0, APOS.length);
                    continue block7;
                }
                case '\"': {
                    writer.write(QUOT, 0, QUOT.length);
                    continue block7;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }

    public static QName toQName(String namespaceURI, String localName, String qName) {
        if (namespaceURI != null) {
            int colonIndex;
            if (!namespaceURI.isEmpty() && qName != null && (colonIndex = qName.indexOf(58)) != -1) {
                String prefix = qName.substring(0, colonIndex);
                String qNameLocalName = qName.substring(colonIndex + 1);
                return new QName(namespaceURI.intern(), qNameLocalName, prefix);
            }
            if (localName != null && !localName.isEmpty()) {
                return new QName(namespaceURI, localName);
            }
            if (qName != null && !qName.isEmpty()) {
                return new QName(namespaceURI, qName);
            }
            XmlUtils.throwInvalidNameException(namespaceURI, localName, qName);
        } else {
            if (localName != null && !localName.isEmpty()) {
                return new QName(localName);
            }
            XmlUtils.throwInvalidNameException(null, localName, qName);
        }
        return null;
    }

    private static void throwInvalidNameException(String namespaceURI, String localName, String qName) {
        throw new IllegalArgumentException("Invalid QName: namespaceURI='" + namespaceURI + "', localName='" + localName + "', qName='" + qName + "'.");
    }

    static class XMLParseErrorHandler
    implements ErrorHandler {
        private static final XMLParseErrorHandler singleton = new XMLParseErrorHandler();

        private XMLParseErrorHandler() {
        }

        private static XMLParseErrorHandler getInstance() {
            return singleton;
        }

        @Override
        public void warning(SAXParseException arg0) throws SAXException {
            throw arg0;
        }

        @Override
        public void error(SAXParseException arg0) throws SAXException {
            throw arg0;
        }

        @Override
        public void fatalError(SAXParseException arg0) throws SAXException {
            throw arg0;
        }
    }

    public static enum VALIDATION_TYPE {
        NONE,
        DTD,
        XSD;

    }
}

