/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import org.smooks.api.SmooksException;
import org.smooks.assertion.AssertArgument;
import org.smooks.support.ClassUtils;
import org.smooks.support.StreamUtils;
import org.smooks.xml.XsdValidator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.SAXException;

public class XsdDOMValidator
extends XsdValidator {
    private final Document document;
    private URI defaultNamespace;
    private final List<URI> namespaces = new ArrayList<URI>();

    public XsdDOMValidator(Document document) throws SAXException {
        AssertArgument.isNotNull(document, "document");
        this.document = document;
        String defaultNamespaceString = XsdDOMValidator.getDefaultNamespace(document.getDocumentElement());
        if (defaultNamespaceString != null) {
            try {
                this.defaultNamespace = new URI(defaultNamespaceString);
            }
            catch (URISyntaxException e) {
                throw new SAXException("Cannot validate this document with this class.  Namespaces must be valid URIs.  Default Namespace: '" + defaultNamespaceString + "'.", e);
            }
        }
        this.namespaces.addAll(this.collectNamespaces(document.getDocumentElement()));
        this.setSchemaSourceResolver((type, namespaceURI, publicId, systemId, baseURI) -> new LSInput(){

            @Override
            public Reader getCharacterStream() {
                return null;
            }

            @Override
            public void setCharacterStream(Reader characterStream) {
            }

            @Override
            public InputStream getByteStream() {
                return null;
            }

            @Override
            public void setByteStream(InputStream byteStream) {
            }

            @Override
            public String getStringData() {
                if (namespaceURI != null) {
                    try {
                        return XsdDOMValidator.this.getNamespaceSource(new URI(namespaceURI));
                    }
                    catch (URISyntaxException e) {
                        throw new SmooksException(e.getMessage(), (Throwable)e);
                    }
                }
                return null;
            }

            @Override
            public void setStringData(String stringData) {
            }

            @Override
            public String getSystemId() {
                return null;
            }

            @Override
            public void setSystemId(String systemId) {
            }

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public void setPublicId(String publicId) {
            }

            @Override
            public String getBaseURI() {
                return null;
            }

            @Override
            public void setBaseURI(String baseURI) {
            }

            @Override
            public String getEncoding() {
                return null;
            }

            @Override
            public void setEncoding(String encoding) {
            }

            @Override
            public boolean getCertifiedText() {
                return false;
            }

            @Override
            public void setCertifiedText(boolean certifiedText) {
            }
        });
    }

    public URI getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public List<URI> getNamespaces() {
        return this.namespaces;
    }

    public void validate() throws SAXException, IOException {
        this.validate(new DOMSource(this.document));
    }

    public static String getDefaultNamespace(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int attributeCount = attributes.getLength();
        for (int i = 0; i < attributeCount; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (!"xmlns".equals(attribute.getName()) || !"xmlns".equals(attribute.getLocalName())) continue;
            return attribute.getValue();
        }
        return null;
    }

    private List<URI> collectNamespaces(Element element) throws SAXException {
        ArrayList<URI> namespaceSources = new ArrayList<URI>();
        NamedNodeMap attributes = element.getAttributes();
        int attributeCount = attributes.getLength();
        for (int i = 0; i < attributeCount; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespace = attribute.getNamespaceURI();
            if (!"http://www.w3.org/2000/xmlns/".equals(namespace)) continue;
            try {
                namespaceSources.add(new URI(attribute.getValue()));
                continue;
            }
            catch (URISyntaxException e) {
                throw new SAXException("Cannot validate this document with this class.  Namespaces must be valid URIs.  Found Namespace: '" + attribute.getValue() + "'.", e);
            }
        }
        NodeList childNodes = element.getChildNodes();
        int childCount = childNodes.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            namespaceSources.addAll(this.collectNamespaces((Element)child));
        }
        return namespaceSources;
    }

    private String getNamespaceSource(URI namespace) {
        if (namespace.getPath().length() > 0) {
            String resourcePath = "/META-INF" + namespace.getPath();
            InputStream xsdStream = ClassUtils.getResourceAsStream(resourcePath, this.getClass());
            if (xsdStream == null) {
                return null;
            }
            try {
                return new String(StreamUtils.readStream(xsdStream));
            }
            catch (IOException e) {
                throw new SmooksException(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

