/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.dynamic.visitor;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.cartridges.javabean.dynamic.BeanMetadata;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.resource.visitor.dom.DefaultDOMSerializerVisitor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnknownElementDataReaper {
    protected static final DefaultDOMSerializerVisitor SERIALIZER_VISITOR = new DefaultDOMSerializerVisitor();

    public static String getPreText(Element element, List<BeanMetadata> beanMetadataSet) {
        String xml;
        StringWriter serializeWriter = new StringWriter();
        ArrayList<Element> toSerializeNodes = new ArrayList<Element>();
        Node current = element;
        while (!(current == null || (current = current.getPreviousSibling()) == null || current instanceof Element && UnknownElementDataReaper.isOnModelSourcePath(current, beanMetadataSet))) {
            toSerializeNodes.add(0, (Element)current);
        }
        for (Node node : toSerializeNodes) {
            try {
                UnknownElementDataReaper.serialize(node, serializeWriter);
            }
            catch (IOException e) {
                throw new SmooksException("Unexpected pre-text node serialization exception.", (Throwable)e);
            }
        }
        try {
            xml = UnknownElementDataReaper.normalizeLines(serializeWriter.toString());
        }
        catch (IOException iOException) {
            throw new SmooksException("Unexpected pre-text node serialization exception while attempting to remove excess whitespace.", (Throwable)iOException);
        }
        StringBuilder stringBuilder = new StringBuilder(xml);
        while (stringBuilder.length() > 0 && stringBuilder.charAt(0) == ' ') {
            stringBuilder.deleteCharAt(0);
        }
        while (stringBuilder.length() > 1 && stringBuilder.charAt(0) == '\n' && stringBuilder.charAt(1) == '\n') {
            stringBuilder.deleteCharAt(0);
        }
        while (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ' ') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        while (stringBuilder.length() > 1 && stringBuilder.charAt(stringBuilder.length() - 1) == '\n' && stringBuilder.charAt(stringBuilder.length() - 2) == '\n') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    protected static boolean isOnModelSourcePath(Node node, List<BeanMetadata> beanMetadataSet) {
        for (BeanMetadata beanMetadata : beanMetadataSet) {
            if (node.equals(beanMetadata.getCreateSource().unwrap())) {
                return true;
            }
            for (Fragment populateSourceFragment : beanMetadata.getPopulateSources()) {
                if (!(populateSourceFragment instanceof NodeFragment) || !UnknownElementDataReaper.isEqualOrDescendant((Node)populateSourceFragment.unwrap(), node)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEqualOrDescendant(Node nodeUnderTest, Node candidateNode) {
        while (nodeUnderTest != null) {
            if (nodeUnderTest == candidateNode) {
                return true;
            }
            nodeUnderTest = nodeUnderTest.getParentNode();
        }
        return false;
    }

    public static String normalizeLines(String xml) throws IOException {
        StringBuffer stringBuf = new StringBuffer();
        int xmlLength = xml.length();
        for (int i = 0; i < xmlLength; ++i) {
            char character = xml.charAt(i);
            if (character == '\r') continue;
            stringBuf.append(character);
        }
        return stringBuf.toString();
    }

    private static void serialize(Node node, Writer writer) throws IOException {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            NodeList children = element.getChildNodes();
            int childCount = children.getLength();
            SERIALIZER_VISITOR.writeStartElement(element, writer, null);
            for (int i = 0; i < childCount; ++i) {
                UnknownElementDataReaper.serialize(children.item(i), writer);
            }
            SERIALIZER_VISITOR.writeEndElement(element, writer, null);
        } else {
            SERIALIZER_VISITOR.writeCharacterData(node, writer, null);
        }
    }

    static {
        SERIALIZER_VISITOR.setCloseEmptyElements(Optional.of(true));
        SERIALIZER_VISITOR.setRewriteEntities(Optional.of(true));
        SERIALIZER_VISITOR.postConstruct();
    }
}

