/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.converter;

import jakarta.annotation.PostConstruct;
import java.util.Properties;
import java.util.function.Function;
import javax.inject.Inject;
import org.smooks.api.ApplicationContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.resource.config.Configurable;
import org.smooks.cartridges.javabean.converter.PreprocessTypeConverter;
import org.smooks.engine.lookup.converter.NameTypeConverterFactoryLookup;
import org.smooks.support.ClassUtils;

public class PreprocessTypeConverterFactory
implements Configurable,
TypeConverterFactory<String, Object> {
    public static final String VALUE_PRE_PROCESSING = "valuePreprocess";
    public static final String DELEGATE_TYPE_CONVERTER_FACTORY = "baseDecoder";
    @Inject
    protected ApplicationContext applicationContext;
    protected Properties properties;
    protected TypeConverterFactory<? super String, ?> delegateTypeConverterFactory;

    @PostConstruct
    public void postConstruct() {
        String delegateTypeConverterFactoryName = this.properties.getProperty(DELEGATE_TYPE_CONVERTER_FACTORY);
        if (delegateTypeConverterFactoryName != null) {
            try {
                Class typeConverterFactoryClass = ClassUtils.forName((String)delegateTypeConverterFactoryName, TypeConverterFactory.class);
                try {
                    this.delegateTypeConverterFactory = (TypeConverterFactory)typeConverterFactoryClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new TypeConverterException("Failed to load TypeConverterFactory class '" + typeConverterFactoryClass.getName() + "'.", (Throwable)e);
                }
            }
            catch (ClassNotFoundException e) {
                this.delegateTypeConverterFactory = (TypeConverterFactory)this.applicationContext.getRegistry().lookup((Function)new NameTypeConverterFactoryLookup(delegateTypeConverterFactoryName));
            }
        }
    }

    public TypeConverter<? super String, ?> createTypeConverter() {
        TypeConverter delegateTypeConverter = this.delegateTypeConverterFactory.createTypeConverter();
        if (delegateTypeConverter instanceof Configurable) {
            ((Configurable)delegateTypeConverter).setConfiguration(this.properties);
        }
        return new PreprocessTypeConverter(this.properties.getProperty(VALUE_PRE_PROCESSING), delegateTypeConverter);
    }

    public TypeConverterDescriptor<Class<String>, Class<Object>> getTypeConverterDescriptor() {
        throw new UnsupportedOperationException();
    }

    public void setConfiguration(Properties properties) throws SmooksConfigException {
        this.properties = properties;
    }

    public Properties getConfiguration() {
        return this.properties;
    }

    public TypeConverterFactory<? super String, ?> getDelegateTypeConverterFactory() {
        return this.delegateTypeConverterFactory;
    }

    public void setDelegateTypeConverterFactory(TypeConverterFactory<? super String, ?> delegateTypeConverterFactory) {
        this.delegateTypeConverterFactory = delegateTypeConverterFactory;
    }
}

