/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.dynamic;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.javabean.dynamic.BeanMetadata;
import org.smooks.cartridges.javabean.dynamic.BeanRegistrationException;
import org.smooks.cartridges.javabean.dynamic.ModelBuilder;
import org.smooks.cartridges.javabean.dynamic.serialize.BeanWriter;
import org.smooks.cartridges.javabean.dynamic.serialize.DefaultNamespace;
import org.smooks.io.sink.JavaSink;

public class Model<T> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Model.class);
    protected final T modelRoot;
    protected final List<BeanMetadata> modelMetadata;
    protected final Map<Class<?>, Map<String, BeanWriter>> beanWriters;
    protected final Map<String, String> namespacePrefixMappings;
    protected Set<String> knownNamespaces;

    public Model(T modelRoot, ModelBuilder builder) {
        AssertArgument.isNotNull(modelRoot, (String)"modelRoot");
        AssertArgument.isNotNull((Object)builder, (String)"builder");
        this.modelRoot = modelRoot;
        this.modelMetadata = new ArrayList<BeanMetadata>();
        this.beanWriters = builder.getDescriptor().getBeanWriters();
        this.namespacePrefixMappings = new LinkedHashMap<String, String>();
        this.resolveKnownNamespaces();
        this.registerBean(modelRoot);
    }

    protected Model(T modelRoot, List<BeanMetadata> modelMetadata, Map<Class<?>, Map<String, BeanWriter>> beanWriters, Map<String, String> namespacePrefixMappings) {
        AssertArgument.isNotNull(modelRoot, (String)"modelRoot");
        AssertArgument.isNotNull(modelMetadata, (String)"modelMetadata");
        AssertArgument.isNotNull(beanWriters, (String)"beanWriters");
        AssertArgument.isNotNull(namespacePrefixMappings, (String)"namespacePrefixMappings");
        this.modelRoot = modelRoot;
        this.modelMetadata = modelMetadata;
        this.beanWriters = beanWriters;
        this.namespacePrefixMappings = namespacePrefixMappings;
        this.resolveKnownNamespaces();
    }

    public T getModelRoot() {
        return this.modelRoot;
    }

    protected void resolveKnownNamespaces() {
        this.knownNamespaces = new HashSet<String>();
        Collection<Map<String, BeanWriter>> namespacedBeanWritersI = this.beanWriters.values();
        for (Map<String, BeanWriter> namespacedBeanWritersII : namespacedBeanWritersI) {
            this.knownNamespaces.addAll(namespacedBeanWritersII.keySet());
        }
    }

    public BeanMetadata registerBean(Object beanInstance) throws BeanRegistrationException {
        AssertArgument.isNotNull((Object)beanInstance, (String)"beanInstance");
        if (this.getBeanMetadata(beanInstance) != null) {
            BeanRegistrationException.throwBeanInstanceAlreadyRegisteredException(beanInstance);
        }
        BeanMetadata metadata = new BeanMetadata(beanInstance);
        this.modelMetadata.add(metadata);
        DefaultNamespace defaultNs = beanInstance.getClass().getAnnotation(DefaultNamespace.class);
        if (defaultNs == null) {
            BeanRegistrationException.throwBeanNotAnnotatedWithDefaultNamespace(beanInstance);
        }
        metadata.setNamespace(defaultNs.uri());
        metadata.setNamespacePrefix(defaultNs.prefix());
        return metadata;
    }

    public List<BeanMetadata> getModelMetadata() {
        return this.modelMetadata;
    }

    public BeanMetadata getBeanMetadata(Object beanInstance) {
        AssertArgument.isNotNull((Object)beanInstance, (String)"beanInstance");
        for (BeanMetadata beanMetadata : this.modelMetadata) {
            if (beanMetadata.getBean() != beanInstance) continue;
            return beanMetadata;
        }
        return null;
    }

    public synchronized void writeModel(Writer writer) throws BeanRegistrationException, IOException {
        Object rootBean;
        AssertArgument.isNotNull((Object)writer, (String)"writer");
        if (this.modelRoot instanceof JavaSink) {
            JavaSink javaSink = (JavaSink)this.modelRoot;
            Map beanMap = javaSink.getResultMap();
            if (beanMap.isEmpty()) {
                throw new IOException("Unable to serialize empty JavaResult Model.");
            }
            if (beanMap.size() > 1) {
                throw new IOException("Unable to serialize JavaResult Model that contains more than 1 bean instance.");
            }
            rootBean = beanMap.values().iterator().next();
        } else {
            rootBean = this.modelRoot;
        }
        this.resolveModelNamespaces();
        this.resolveUnmappedBeanWriters();
        BeanWriter beanWriter = this.getBeanWriter(rootBean);
        beanWriter.write(rootBean, writer, this);
    }

    public Map<String, String> getNamespacePrefixMappings() {
        return this.namespacePrefixMappings;
    }

    public BeanWriter getBeanWriter(Object bean) throws BeanRegistrationException {
        BeanMetadata beanMetadata = this.getBeanMetadata(bean);
        if (beanMetadata == null) {
            BeanRegistrationException.throwUnregisteredBeanInstanceException(bean);
        }
        return beanMetadata.getWriter();
    }

    protected void resolveModelNamespaces() {
        this.removeKnownNamespaceMappings();
        this.updateMetadataPrefixes();
        this.addMissingNamespaceMappings();
    }

    protected void updateMetadataPrefixes() {
        for (BeanMetadata metaData : this.modelMetadata) {
            String declaredPrefix = this.namespacePrefixMappings.get(metaData.getNamespace());
            if (declaredPrefix == null) continue;
            metaData.setNamespacePrefix(declaredPrefix);
        }
    }

    protected void removeKnownNamespaceMappings() {
        HashSet<String> namespaceUris = new HashSet<String>(this.namespacePrefixMappings.keySet());
        for (String namespaceUri : namespaceUris) {
            if (!this.knownNamespaces.contains(namespaceUri) || this.isNamespaceInModel(namespaceUri)) continue;
            this.namespacePrefixMappings.remove(namespaceUri);
        }
    }

    protected void addMissingNamespaceMappings() {
        for (BeanMetadata metaData : this.modelMetadata) {
            String uri = metaData.getNamespace();
            if (this.namespacePrefixMappings.containsKey(uri)) continue;
            this.namespacePrefixMappings.put(uri, metaData.getNamespacePrefix());
        }
    }

    protected boolean isNamespaceInModel(String namespaceUri) {
        for (BeanMetadata metaData : this.modelMetadata) {
            if (!namespaceUri.equals(metaData.getNamespace())) continue;
            return true;
        }
        return false;
    }

    protected void resolveUnmappedBeanWriters() throws IOException {
        for (BeanMetadata metaData : this.modelMetadata) {
            Map<String, BeanWriter> classBeanWriters;
            if (metaData.getWriter() != null || (classBeanWriters = this.beanWriters.get(metaData.getBean().getClass())) == null) continue;
            BeanWriter beanWriter = classBeanWriters.get(metaData.getNamespace());
            if (beanWriter == null) {
                throw new IOException("BeanWriters are configured for Object type '" + metaData.getBean().getClass() + "', but not for namespace '" + metaData.getNamespace() + "'.");
            }
            metaData.setWriter(beanWriter);
        }
    }
}

