/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.gen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.javabean.gen.model.BindingConfig;
import org.smooks.cartridges.javabean.gen.model.ClassConfig;
import org.smooks.engine.converter.TypeConverterFactoryLoader;
import org.smooks.engine.lookup.converter.SourceTargetTypeConverterFactoryLookup;
import org.smooks.support.FreeMarkerTemplate;

public class ConfigGenerator {
    public static final String ROOT_BEAN_CLASS = "root.beanClass";
    public static final String PACKAGES_INCLUDED = "packages.included";
    public static final String PACKAGES_EXCLUDED = "packages.excluded";
    protected final Set<TypeConverterFactory<?, ?>> typeConverterFactories;
    protected final Writer outputWriter;
    protected final Stack<Class<?>> classStack = new Stack();
    protected Class<?> rootBeanClass;
    protected List<String> packagesIncluded;
    protected List<String> packagesExcluded;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        String rootBeanClassName = ConfigGenerator.getArgument("-c", "Root Bean Class Name", true, args);
        String outputFileName = ConfigGenerator.getArgument("-o", "Output File Path", true, args);
        String propertiesFile = ConfigGenerator.getArgument("-p", "Binding Generation Config File Path", false, args);
        Properties properties = ConfigGenerator.loadProperties(propertiesFile);
        File outputFile = new File(outputFileName);
        properties.setProperty(ROOT_BEAN_CLASS, rootBeanClassName);
        if (outputFile.getParentFile() != null) {
            outputFile.getParentFile().mkdirs();
        }
        FileWriter outputWriter = new FileWriter(outputFile);
        try {
            ConfigGenerator generator = new ConfigGenerator(properties, outputWriter, ConfigGenerator.class.getClassLoader());
            generator.generate();
        }
        finally {
            try {
                ((Writer)outputWriter).flush();
            }
            finally {
                ((Writer)outputWriter).close();
            }
        }
    }

    public ConfigGenerator(Properties bindingProperties, Writer outputWriter, ClassLoader classLoader) throws ClassNotFoundException {
        AssertArgument.isNotNull((Object)bindingProperties, (String)"bindingProperties");
        AssertArgument.isNotNull((Object)outputWriter, (String)"outputWriter");
        this.outputWriter = outputWriter;
        this.typeConverterFactories = new TypeConverterFactoryLoader().load(classLoader);
        this.configure(bindingProperties);
    }

    public void generate() throws IOException {
        HashMap<String, ArrayList<ClassConfig>> templatingContextObject = new HashMap<String, ArrayList<ClassConfig>>();
        ArrayList<ClassConfig> classConfigs = new ArrayList<ClassConfig>();
        this.addClassConfig(classConfigs, this.rootBeanClass, null);
        FreeMarkerTemplate template = new FreeMarkerTemplate("templates/bindingConfig.ftl.xml", this.getClass());
        templatingContextObject.put("classConfigs", classConfigs);
        this.outputWriter.write(template.apply(templatingContextObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassConfig addClassConfig(List<ClassConfig> classConfigs, Class<?> beanClass, String beanId) {
        if (this.classStack.contains(beanClass)) {
            return null;
        }
        this.classStack.push(beanClass);
        try {
            ClassConfig classConfig = new ClassConfig(beanClass, beanId);
            Field[] fields = beanClass.getDeclaredFields();
            List<BindingConfig> bindings = classConfig.getBindings();
            String rootPackage = this.rootBeanClass.getPackage() != null ? this.rootBeanClass.getPackage().getName() : "";
            classConfigs.add(classConfig);
            for (Field field : fields) {
                Class<?> type = field.getType();
                TypeConverterFactory typeConverterFactory = new SourceTargetTypeConverterFactoryLookup(String.class, type).lookup(this.typeConverterFactories);
                if (typeConverterFactory != null) {
                    bindings.add(new BindingConfig(field, this.typeConverterFactories));
                    continue;
                }
                if (type.isArray()) {
                    this.addArrayConfig(classConfigs, bindings, rootPackage, field);
                    continue;
                }
                if (Collection.class.isAssignableFrom(type)) {
                    this.addCollectionConfig(classConfigs, bindings, rootPackage, field);
                    continue;
                }
                String typePackage = type.getPackage().getName();
                if (this.isExcluded(typePackage) || !typePackage.startsWith(rootPackage) && !this.isIncluded(typePackage)) continue;
                bindings.add(new BindingConfig(field, field.getName(), this.typeConverterFactories));
                this.addClassConfig(classConfigs, type, field.getName());
            }
            ClassConfig classConfig2 = classConfig;
            return classConfig2;
        }
        finally {
            this.classStack.pop();
        }
    }

    protected void addArrayConfig(List<ClassConfig> classConfigs, List<BindingConfig> bindings, String rootPackage, Field field) {
        Class<?> type = field.getType();
        Class<?> arrayType = type.getComponentType();
        String wireBeanId = field.getName() + "_entry";
        String typePackage = arrayType.getPackage().getName();
        if (this.isExcluded(typePackage)) {
            return;
        }
        if (typePackage.startsWith(rootPackage) || this.isIncluded(typePackage)) {
            ClassConfig arrayConfig = new ClassConfig(arrayType, field.getName());
            arrayConfig.getBindings().add(new BindingConfig(wireBeanId, this.typeConverterFactories));
            arrayConfig.setArray(true);
            classConfigs.add(arrayConfig);
            bindings.add(new BindingConfig(field, field.getName(), this.typeConverterFactories));
            this.addClassConfig(classConfigs, arrayType, wireBeanId);
        }
    }

    protected void addCollectionConfig(List<ClassConfig> classConfigs, List<BindingConfig> bindings, String rootPackage, Field field) {
        ParameterizedType paramType = (ParameterizedType)field.getGenericType();
        Type[] types = paramType.getActualTypeArguments();
        if (types.length != 0) {
            Class type = (Class)types[0];
            String wireBeanId = field.getName() + "_entry";
            String typePackage = type.getPackage().getName();
            if (this.isExcluded(typePackage)) {
                return;
            }
            if (typePackage.startsWith(rootPackage) || this.isIncluded(typePackage)) {
                ClassConfig listConfig = new ClassConfig(ArrayList.class, field.getName());
                listConfig.getBindings().add(new BindingConfig(wireBeanId, this.typeConverterFactories));
                classConfigs.add(listConfig);
                bindings.add(new BindingConfig(field, field.getName(), this.typeConverterFactories));
                this.addClassConfig(classConfigs, type, wireBeanId);
            }
        }
    }

    protected boolean isIncluded(String packageName) {
        if (this.packagesIncluded != null) {
            return this.isInPackageList(this.packagesIncluded, packageName);
        }
        return false;
    }

    protected boolean isExcluded(String packageName) {
        if (this.packagesExcluded != null) {
            return this.isInPackageList(this.packagesExcluded, packageName);
        }
        return false;
    }

    protected boolean isInPackageList(List<String> packages, String typePackage) {
        for (String packageName : packages) {
            if (!typePackage.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    protected void configure(Properties bindingProperties) throws ClassNotFoundException {
        String rootBeanClassConfig = bindingProperties.getProperty(ROOT_BEAN_CLASS);
        String packagesIncludedConfig = bindingProperties.getProperty(PACKAGES_INCLUDED);
        String packagesExcludedConfig = bindingProperties.getProperty(PACKAGES_EXCLUDED);
        if (rootBeanClassConfig == null) {
            throw new IllegalArgumentException("Binding configuration property 'root.beanClass' not defined.");
        }
        this.rootBeanClass = Class.forName(rootBeanClassConfig);
        if (packagesIncludedConfig != null) {
            this.packagesIncluded = this.parsePackages(packagesIncludedConfig);
        }
        if (packagesExcludedConfig != null) {
            this.packagesExcluded = this.parsePackages(packagesExcludedConfig);
        }
    }

    protected List<String> parsePackages(String packagesString) {
        String[] packages = packagesString.split(";");
        ArrayList<String> packagesSet = new ArrayList<String>();
        for (String aPackage : packages) {
            packagesSet.add(aPackage.trim());
        }
        return packagesSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties loadProperties(String fileName) throws IOException {
        Properties properties = new Properties();
        if (fileName != null) {
            File propertiesFile = new File(fileName);
            if (!propertiesFile.exists()) {
                throw new IllegalArgumentException("Binding configuration properties file '" + propertiesFile.getAbsolutePath() + "' doesn't exist.  See class Javadoc.");
            }
            try (FileInputStream stream = new FileInputStream(propertiesFile);){
                properties.load(stream);
            }
        }
        return properties;
    }

    protected static String getArgument(String argAlias, String argName, boolean mandatory, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(argAlias) || i + 1 >= args.length) continue;
            return args[i + 1].trim();
        }
        if (mandatory) {
            throw new IllegalArgumentException("Binding configuration error.  Missing value for commandline arg '" + argAlias + "' (" + argName + ")'.");
        }
        return null;
    }
}

