/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.ext;

import java.util.Properties;
import java.util.UUID;
import java.util.function.Function;
import javax.inject.Inject;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.dom.DOMVisitBefore;
import org.smooks.cartridges.javabean.converter.PreprocessTypeConverterFactory;
import org.smooks.engine.lookup.converter.NameTypeConverterFactoryLookup;
import org.smooks.engine.resource.config.DefaultResourceConfig;
import org.smooks.engine.resource.config.loader.xml.extension.ExtensionContext;
import org.smooks.support.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DecodeParamResolver
implements DOMVisitBefore {
    @Inject
    protected ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        NodeList decodeParams = element.getElementsByTagNameNS(element.getNamespaceURI(), "decodeParam");
        if (decodeParams.getLength() > 0) {
            ExtensionContext extensionContext = (ExtensionContext)executionContext.get(ExtensionContext.EXTENSION_CONTEXT_TYPED_KEY);
            ResourceConfig populatorConfig = (ResourceConfig)extensionContext.getResourceStack().peek();
            DefaultResourceConfig typeConverterFactoryResourceConfig = new DefaultResourceConfig();
            extensionContext.addResourceConfig((ResourceConfig)typeConverterFactoryResourceConfig);
            try {
                String type = (String)populatorConfig.getParameterValue("type", String.class);
                TypeConverterFactory typeConverterFactory = (TypeConverterFactory)this.applicationContext.getRegistry().lookup((Function)new NameTypeConverterFactoryLookup(type));
                String reType = "_" + UUID.randomUUID();
                populatorConfig.removeParameter("type");
                populatorConfig.setParameter("type", (Object)reType);
                typeConverterFactoryResourceConfig.setSelector("decoder:" + reType, new Properties());
                typeConverterFactoryResourceConfig.setProfile(extensionContext.getDefaultProfile());
                if (type != null) {
                    typeConverterFactoryResourceConfig.setResource(typeConverterFactory.getClass().getName());
                }
                for (int i = 0; i < decodeParams.getLength(); ++i) {
                    Element decoderParam = (Element)decodeParams.item(i);
                    String name = decoderParam.getAttribute("name");
                    if (name.equals("valuePreprocess")) {
                        typeConverterFactoryResourceConfig.setResource(PreprocessTypeConverterFactory.class.getName());
                        if (type != null) {
                            typeConverterFactoryResourceConfig.setParameter("baseDecoder", (Object)typeConverterFactory.getClass().getName());
                        }
                    }
                    typeConverterFactoryResourceConfig.setParameter(name, (Object)DomUtils.getAllText((Element)decoderParam, (boolean)true));
                }
            }
            finally {
                extensionContext.getResourceStack().pop();
            }
        }
    }
}

