/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.smooks.api.Registry;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.javabean.BeanInstanceCreator;
import org.smooks.cartridges.javabean.BeanInstancePopulator;
import org.smooks.cartridges.javabean.BeanRuntimeInfo;
import org.smooks.cartridges.javabean.BindingAppender;
import org.smooks.cartridges.javabean.ext.SelectorPropertyResolver;
import org.smooks.cartridges.javabean.factory.Factory;
import org.smooks.engine.converter.TypeConverterFactoryLoader;
import org.smooks.engine.delivery.DefaultContentHandlerBinding;
import org.smooks.engine.lookup.NamespaceManagerLookup;
import org.smooks.engine.lookup.converter.SourceTargetTypeConverterFactoryLookup;
import org.smooks.engine.resource.config.DefaultResourceConfig;
import org.smooks.support.ClassUtils;

public class Bean
extends BindingAppender {
    protected static volatile Set<TypeConverterFactory<?, ?>> TYPE_CONVERTER_FACTORIES = null;
    protected final Registry registry;
    protected final BeanInstanceCreator beanInstanceCreator;
    protected final Class<?> beanClass;
    protected final String createOnElement;
    protected final List<Binding> bindings = new ArrayList<Binding>();
    protected final List<Bean> wirings = new ArrayList<Bean>();
    protected boolean processed = false;

    public Bean(Class<?> beanClass, String beanId, Registry registry) {
        this(beanClass, beanId, (Factory)null, registry);
    }

    public <T> Bean(Class<T> beanClass, String beanId, Factory<? extends T> factory, Registry registry) {
        this(beanClass, beanId, "#document", factory, registry);
    }

    public Bean(Class<?> beanClass, String beanId, String createOnElement, Registry registry) {
        this(beanClass, beanId, createOnElement, null, registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public <T> Bean(Class<T> beanClass, String beanId, String createOnElement, Factory<? extends T> factory, Registry registry) {
        super(beanId);
        AssertArgument.isNotNull(beanClass, (String)"beanClass");
        AssertArgument.isNotNull((Object)createOnElement, (String)"createOnElement");
        if (TYPE_CONVERTER_FACTORIES == null) {
            Class<Bean> clazz = Bean.class;
            // MONITORENTER : org.smooks.cartridges.javabean.Bean.class
            if (TYPE_CONVERTER_FACTORIES == null) {
                TYPE_CONVERTER_FACTORIES = new TypeConverterFactoryLoader().load(registry.getClassLoader());
            }
            // MONITOREXIT : clazz
        }
        this.beanClass = beanClass;
        this.createOnElement = createOnElement;
        this.registry = registry;
        this.beanInstanceCreator = new BeanInstanceCreator(beanId, beanClass, factory);
    }

    public static Bean newBean(Class<?> beanClass, String beanId, String createOnElement, Registry registry) {
        return new Bean(beanClass, beanId, createOnElement, registry);
    }

    public static <T> Bean newBean(Class<T> beanClass, String beanId, String createOnElement, Factory<T> factory, Registry registry) {
        return new Bean(beanClass, beanId, createOnElement, factory, registry);
    }

    public Bean newBean(Class<?> beanClass, String createOnElement) {
        String randomBeanId = UUID.randomUUID().toString();
        return new Bean(beanClass, randomBeanId, createOnElement, this.registry);
    }

    public <T> Bean newBean(Class<T> beanClass, String createOnElement, Factory<T> factory) {
        return new Bean(beanClass, UUID.randomUUID().toString(), createOnElement, factory, this.registry);
    }

    public Bean newBean(Class<?> beanClass, String beanId, String createOnElement) {
        return new Bean(beanClass, beanId, createOnElement, this.registry);
    }

    public <T> Bean newBean(Class<T> beanClass, String beanId, String createOnElement, Factory<T> factory) {
        return new Bean(beanClass, beanId, createOnElement, factory, this.registry);
    }

    public Bean bindTo(String bindingMember, String dataSelector) {
        return this.bindTo(bindingMember, dataSelector, null);
    }

    public Bean bindTo(String bindingMember, String dataSelector, TypeConverterFactory<?, ?> typeConverterFactory) {
        this.assertNotProcessed();
        AssertArgument.isNotNull((Object)bindingMember, (String)"bindingMember");
        AssertArgument.isNotNull((Object)dataSelector, (String)"dataSelector");
        BeanInstancePopulator beanInstancePopulator = new BeanInstancePopulator();
        DefaultResourceConfig populatorResourceConfig = new DefaultResourceConfig(dataSelector, ((Optional)this.registry.lookup((Function)new NamespaceManagerLookup())).orElse(new Properties()));
        SelectorPropertyResolver.resolveSelectorTokens((ResourceConfig)populatorResourceConfig);
        beanInstancePopulator.setBeanId(this.getBeanId());
        beanInstancePopulator.setValueAttributeName((String)populatorResourceConfig.getParameterValue("valueAttributeName", String.class));
        beanInstancePopulator.setValueAttributePrefix((String)populatorResourceConfig.getParameterValue("valueAttributePrefix", String.class));
        Method bindingMethod = Bean.getBindingMethod(bindingMember, this.beanClass);
        if (bindingMethod != null) {
            if (typeConverterFactory == null) {
                Class<?> dataType = bindingMethod.getParameterTypes()[0];
                TypeConverterFactory stringTypeConverterFactory = new SourceTargetTypeConverterFactoryLookup(String.class, dataType).lookup(TYPE_CONVERTER_FACTORIES);
                typeConverterFactory = stringTypeConverterFactory != null ? stringTypeConverterFactory : new SourceTargetTypeConverterFactoryLookup(Object.class, Object.class).lookup(TYPE_CONVERTER_FACTORIES);
            }
            if (bindingMethod.getName().equals(bindingMember)) {
                beanInstancePopulator.setSetterMethod(bindingMethod.getName());
            } else {
                beanInstancePopulator.setProperty(bindingMember);
            }
        } else {
            beanInstancePopulator.setProperty(bindingMember);
        }
        beanInstancePopulator.setTypeConverterFactory(typeConverterFactory);
        this.bindings.add(new Binding(populatorResourceConfig.getSelectorPath().getSelector(), beanInstancePopulator, false));
        return this;
    }

    public Bean bindTo(String bindingMember, Bean bean) {
        this.assertNotProcessed();
        AssertArgument.isNotNull((Object)bindingMember, (String)"bindingMember");
        AssertArgument.isNotNull((Object)bean, (String)"bean");
        BeanInstancePopulator beanInstancePopulator = new BeanInstancePopulator();
        beanInstancePopulator.setBeanId(this.getBeanId());
        beanInstancePopulator.setWireBeanId(bean.getBeanId());
        Method bindingMethod = Bean.getBindingMethod(bindingMember, this.beanClass);
        if (bindingMethod != null) {
            if (bindingMethod.getName().equals(bindingMember)) {
                beanInstancePopulator.setSetterMethod(bindingMethod.getName());
            } else {
                beanInstancePopulator.setProperty(bindingMember);
            }
        } else {
            beanInstancePopulator.setProperty(bindingMember);
        }
        this.bindings.add(new Binding(this.createOnElement, beanInstancePopulator, false));
        this.wirings.add(bean);
        return this;
    }

    public Bean bindTo(Bean bean) throws IllegalArgumentException {
        this.assertNotProcessed();
        AssertArgument.isNotNull((Object)bean, (String)"bean");
        BeanInstancePopulator beanInstancePopulator = new BeanInstancePopulator();
        beanInstancePopulator.setBeanId(this.getBeanId());
        beanInstancePopulator.setWireBeanId(bean.getBeanId());
        this.bindings.add(new Binding(this.createOnElement, beanInstancePopulator, true));
        this.wirings.add(bean);
        return this;
    }

    public Bean bindTo(String dataSelector) {
        return this.bindTo(dataSelector, (TypeConverterFactory)null);
    }

    public Bean bindTo(String dataSelector, TypeConverterFactory<String, ?> typeConverterFactory) {
        this.assertNotProcessed();
        AssertArgument.isNotNull((Object)dataSelector, (String)"dataSelector");
        BeanInstancePopulator beanInstancePopulator = new BeanInstancePopulator();
        DefaultResourceConfig populatorResourceConfig = new DefaultResourceConfig(dataSelector, new Properties());
        SelectorPropertyResolver.resolveSelectorTokens((ResourceConfig)populatorResourceConfig);
        beanInstancePopulator.setBeanId(this.getBeanId());
        beanInstancePopulator.setValueAttributeName((String)populatorResourceConfig.getParameterValue("valueAttributeName", String.class));
        beanInstancePopulator.setValueAttributePrefix((String)populatorResourceConfig.getParameterValue("valueAttributePrefix", String.class));
        beanInstancePopulator.setTypeConverterFactory(typeConverterFactory);
        this.bindings.add(new Binding(populatorResourceConfig.getSelectorPath().getSelector(), beanInstancePopulator, true));
        return this;
    }

    public List<ContentHandlerBinding<Visitor>> addVisitors() {
        if (this.processed) {
            return Collections.EMPTY_LIST;
        }
        this.processed = true;
        ArrayList<ContentHandlerBinding<Visitor>> visitorBindings = new ArrayList<ContentHandlerBinding<Visitor>>();
        DefaultContentHandlerBinding beanInstanceCreateBinding = new DefaultContentHandlerBinding((ContentHandler)this.beanInstanceCreator, this.createOnElement, this.registry);
        ResourceConfig beanInstanceCreatorSmooksResourceConfiguration = beanInstanceCreateBinding.getResourceConfig();
        beanInstanceCreatorSmooksResourceConfiguration.setParameter("beanId", (Object)this.getBeanId());
        beanInstanceCreatorSmooksResourceConfiguration.setParameter("beanClass", (Object)this.beanClass.getName());
        visitorBindings.add((ContentHandlerBinding<Visitor>)beanInstanceCreateBinding);
        for (Bean bean : this.wirings) {
            visitorBindings.addAll(bean.addVisitors());
        }
        for (Binding binding : this.bindings) {
            DefaultContentHandlerBinding beanInstancePopulatorBinding = new DefaultContentHandlerBinding((ContentHandler)binding.beanInstancePopulator, binding.selector, this.registry);
            beanInstancePopulatorBinding.getResourceConfig().setParameter("beanId", (Object)this.getBeanId());
            visitorBindings.add((ContentHandlerBinding<Visitor>)beanInstancePopulatorBinding);
            if (!binding.assertTargetIsCollection) continue;
            this.assertBeanClassIsCollection();
        }
        return visitorBindings;
    }

    public static Method getBindingMethod(String bindingMember, Class<?> beanClass) {
        Method[] methods;
        for (Method method : methods = beanClass.getMethods()) {
            if (!method.getName().equals(bindingMember) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        String asPropertySetterMethod = ClassUtils.toSetterName((String)bindingMember);
        for (Method method : methods) {
            if (!method.getName().equals(asPropertySetterMethod) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    protected void assertBeanClassIsCollection() {
        BeanRuntimeInfo beanRuntimeInfo = this.beanInstanceCreator.getBeanRuntimeInfo();
        if (beanRuntimeInfo.getClassification() != BeanRuntimeInfo.Classification.COLLECTION_COLLECTION && beanRuntimeInfo.getClassification() != BeanRuntimeInfo.Classification.ARRAY_COLLECTION) {
            throw new IllegalArgumentException("Invalid call to a Collection/array Bean.bindTo method for a non Collection/Array target.  Binding target type '" + beanRuntimeInfo.getPopulateType().getName() + "' (beanId '" + this.getBeanId() + "').  Use one of the Bean.bindTo methods that specify a 'bindingMember' argument.");
        }
    }

    protected void assertNotProcessed() {
        if (this.processed) {
            throw new IllegalStateException("Unexpected attempt to bindTo Bean instance after the Bean instance has been added to a Smooks instance.");
        }
    }

    protected static class Binding {
        protected final String selector;
        protected final BeanInstancePopulator beanInstancePopulator;
        protected final boolean assertTargetIsCollection;

        protected Binding(String selector, BeanInstancePopulator beanInstancePopulator, boolean assertTargetIsCollection) {
            this.selector = selector;
            this.beanInstancePopulator = beanInstancePopulator;
            this.assertTargetIsCollection = assertTargetIsCollection;
        }
    }
}

