/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.dfdl.unparser;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.daffodil.japi.DaffodilUnparseContentHandler;
import org.apache.daffodil.japi.DataProcessor;
import org.apache.daffodil.japi.Diagnostic;
import org.apache.daffodil.japi.ExternalVariableException;
import org.apache.daffodil.japi.UnparseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.delivery.sax.StreamSinkWriter;
import org.smooks.api.memento.Memento;
import org.smooks.api.memento.MementoCaretaker;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.api.resource.visitor.sax.ng.ChildrenVisitor;
import org.smooks.cartridges.dfdl.unparser.DaffodilUnparseContentHandlerMemento;
import org.smooks.cartridges.dfdl.unparser.UnparserDfdlSmooksException;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.io.Stream;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

@StreamSinkWriter
public class DfdlUnparser
implements BeforeVisitor,
AfterVisitor,
ChildrenVisitor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DfdlUnparser.class);
    protected final DataProcessor dataProcessor;
    @Inject
    protected ResourceConfig resourceConfig;

    public DfdlUnparser(DataProcessor dataProcessor) {
        this.dataProcessor = dataProcessor;
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        DaffodilUnparseContentHandlerMemento daffodilUnparseContentHandlerMemento = this.getOrCreateDaffodilUnparseContentHandlerMemento(element, executionContext);
        DaffodilUnparseContentHandler daffodilUnparseContentHandler = daffodilUnparseContentHandlerMemento.getDaffodilUnparseContentHandler();
        if (element.getPrefix() == null || element.getPrefix().equals("")) {
            daffodilUnparseContentHandler.endElement("", element.getLocalName(), element.getLocalName());
        } else {
            daffodilUnparseContentHandler.endElement(element.getNamespaceURI(), element.getLocalName(), element.getPrefix() + ":" + element.getLocalName());
        }
        this.throwIfError(daffodilUnparseContentHandler.getUnparseResult());
        if (daffodilUnparseContentHandlerMemento.getFragment().unwrap().equals(element)) {
            daffodilUnparseContentHandler.endDocument();
            this.throwIfError(daffodilUnparseContentHandler.getUnparseResult());
        }
    }

    protected DaffodilUnparseContentHandlerMemento getOrCreateDaffodilUnparseContentHandlerMemento(Node node, ExecutionContext executionContext) {
        DaffodilUnparseContentHandler daffodilUnparseContentHandler;
        MementoCaretaker mementoCaretaker = executionContext.getMementoCaretaker();
        for (Node parentNode = node; parentNode != null; parentNode = parentNode.getParentNode()) {
            DaffodilUnparseContentHandlerMemento daffodilUnparseContentHandlerMemento = new DaffodilUnparseContentHandlerMemento((Fragment<?>)new NodeFragment(parentNode), (Visitor)this);
            boolean exists = mementoCaretaker.exists((Memento)daffodilUnparseContentHandlerMemento);
            if (!exists) continue;
            mementoCaretaker.restore((Memento)daffodilUnparseContentHandlerMemento);
            return daffodilUnparseContentHandlerMemento;
        }
        try {
            WritableByteChannel writableByteChannel = Channels.newChannel((OutputStream)((WriterOutputStream.Builder)((WriterOutputStream.Builder)WriterOutputStream.builder().setCharset(executionContext.getContentEncoding()).setBufferSize(1024)).setWriteImmediately(true).setWriter(Stream.out((ExecutionContext)executionContext))).get());
            daffodilUnparseContentHandler = this.dataProcessor.withExternalVariables(this.getVariables(executionContext)).newContentHandlerInstance(writableByteChannel);
        }
        catch (IOException | ExternalVariableException e) {
            throw new UnparserDfdlSmooksException(e);
        }
        daffodilUnparseContentHandler.startDocument();
        DaffodilUnparseContentHandlerMemento daffodilUnparseContentHandlerMemento = new DaffodilUnparseContentHandlerMemento((Fragment<?>)new NodeFragment(node), (Visitor)this);
        daffodilUnparseContentHandlerMemento.setDaffodilUnparseContentHandler(daffodilUnparseContentHandler);
        mementoCaretaker.capture((Memento)daffodilUnparseContentHandlerMemento);
        return daffodilUnparseContentHandlerMemento;
    }

    protected AbstractMap<String, String> getVariables(ExecutionContext executionContext) {
        List variablesParameters = this.resourceConfig.getParameters("variables");
        HashMap<String, String> variables = new HashMap<String, String>();
        if (variablesParameters != null) {
            for (Parameter variablesParameter : variablesParameters) {
                Map.Entry variable = (Map.Entry)variablesParameter.getValue();
                ((AbstractMap)variables).put((String)variable.getKey(), (String)variable.getValue());
            }
        }
        return variables;
    }

    public void visitBefore(Element element, ExecutionContext executionContext) {
        DaffodilUnparseContentHandler daffodilUnparseContentHandler = this.getOrCreateDaffodilUnparseContentHandlerMemento(element, executionContext).getDaffodilUnparseContentHandler();
        AttributesImpl attributes = new AttributesImpl();
        if (element.getAttributes() != null) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = namedNodeMap.item(i);
                if (node.getPrefix() == null || node.getPrefix().equals("")) {
                    attributes.addAttribute("", node.getLocalName(), node.getNodeName(), String.valueOf(node.getNodeType()), node.getNodeValue());
                    continue;
                }
                attributes.addAttribute(node.getNamespaceURI(), node.getLocalName(), node.getNodeName(), String.valueOf(node.getNodeType()), node.getNodeValue());
            }
        }
        if (element.getPrefix() == null || element.getPrefix().equals("")) {
            daffodilUnparseContentHandler.startElement("", element.getLocalName(), element.getLocalName(), (Attributes)attributes);
        } else {
            daffodilUnparseContentHandler.startElement(element.getNamespaceURI(), element.getLocalName(), element.getPrefix() + ":" + element.getLocalName(), (Attributes)attributes);
        }
        this.throwIfError(daffodilUnparseContentHandler.getUnparseResult());
    }

    public void visitChildText(CharacterData characterData, ExecutionContext executionContext) {
        DaffodilUnparseContentHandler daffodilUnparseContentHandler = this.getOrCreateDaffodilUnparseContentHandlerMemento(characterData, executionContext).getDaffodilUnparseContentHandler();
        daffodilUnparseContentHandler.characters(characterData.getData().toCharArray(), 0, characterData.getData().length());
        this.throwIfError(daffodilUnparseContentHandler.getUnparseResult());
    }

    public void visitChildElement(Element element, ExecutionContext executionContext) {
    }

    protected void throwIfError(UnparseResult unparseResult) {
        if (unparseResult != null) {
            for (Diagnostic diagnostic : unparseResult.getDiagnostics()) {
                if (diagnostic.isError()) {
                    throw new UnparserDfdlSmooksException(diagnostic.getSomeMessage(), diagnostic.getSomeCause());
                }
                LOGGER.warn(diagnostic.getMessage());
            }
        }
    }

    public DataProcessor getDataProcessor() {
        return this.dataProcessor;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public void setResourceConfig(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
    }
}

