/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.dfdl.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.daffodil.japi.ValidationMode;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ReaderConfigurator;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.dfdl.parser.DfdlParser;
import org.smooks.engine.resource.config.DefaultParameter;
import org.smooks.engine.resource.config.GenericReaderConfigurator;

public class DfdlReaderConfigurator
implements ReaderConfigurator {
    protected final String schemaUri;
    protected Boolean debugging = false;
    protected Boolean cacheOnDisk = false;
    protected ValidationMode validationMode = ValidationMode.Off;
    protected Boolean indent = false;
    protected String targetProfile;
    protected Map<String, String> variables = new HashMap<String, String>();

    public DfdlReaderConfigurator(String schemaUri) {
        AssertArgument.isNotNullAndNotEmpty((String)schemaUri, (String)"schemaUri");
        this.schemaUri = schemaUri;
    }

    public DfdlReaderConfigurator setTargetProfile(String targetProfile) {
        AssertArgument.isNotNullAndNotEmpty((String)targetProfile, (String)"targetProfile");
        this.targetProfile = targetProfile;
        return this;
    }

    public DfdlReaderConfigurator setValidationMode(ValidationMode validationMode) {
        AssertArgument.isNotNull((Object)validationMode, (String)"validationMode");
        this.validationMode = validationMode;
        return this;
    }

    public DfdlReaderConfigurator setVariables(Map<String, String> variables) {
        AssertArgument.isNotNull(variables, (String)"variables");
        this.variables = variables;
        return this;
    }

    public DfdlReaderConfigurator setIndent(Boolean indent) {
        AssertArgument.isNotNull((Object)indent, (String)"indent");
        this.indent = indent;
        return this;
    }

    protected String getDataProcessorFactory() {
        return "org.smooks.cartridges.dfdl.DataProcessorFactory";
    }

    public Boolean getDebugging() {
        return this.debugging;
    }

    public DfdlReaderConfigurator setDebugging(Boolean debugging) {
        AssertArgument.isNotNull((Object)debugging, (String)"debugging");
        this.debugging = debugging;
        return this;
    }

    public Boolean getCacheOnDisk() {
        return this.cacheOnDisk;
    }

    public DfdlReaderConfigurator setCacheOnDisk(Boolean cacheOnDisk) {
        AssertArgument.isNotNull((Object)cacheOnDisk, (String)"cacheOnDisk");
        this.cacheOnDisk = cacheOnDisk;
        return this;
    }

    public List<ResourceConfig> toConfig() {
        GenericReaderConfigurator genericReaderConfigurator = new GenericReaderConfigurator(DfdlParser.class);
        genericReaderConfigurator.getParameters().setProperty("schemaUri", this.schemaUri);
        genericReaderConfigurator.getParameters().setProperty("validationMode", this.validationMode.toString());
        genericReaderConfigurator.getParameters().setProperty("cacheOnDisk", Boolean.toString(this.cacheOnDisk));
        genericReaderConfigurator.getParameters().setProperty("debugging", Boolean.toString(this.debugging));
        genericReaderConfigurator.getParameters().setProperty("indent", Boolean.toString(this.indent));
        genericReaderConfigurator.getParameters().setProperty("dataProcessorFactory", this.getDataProcessorFactory());
        List resourceConfigs = genericReaderConfigurator.toConfig();
        ResourceConfig resourceConfig = (ResourceConfig)resourceConfigs.get(0);
        for (Map.Entry<String, String> variable : this.variables.entrySet()) {
            resourceConfig.setParameter((Parameter)new DefaultParameter("variables", variable));
        }
        resourceConfig.setProfile(this.targetProfile);
        return resourceConfigs;
    }
}

