/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.dfdl.parser;

import java.util.Stack;
import org.apache.daffodil.japi.infoset.InfosetOutputter;
import org.apache.daffodil.runtime1.api.InfosetArray;
import org.apache.daffodil.runtime1.api.InfosetComplexElement;
import org.apache.daffodil.runtime1.api.InfosetElement;
import org.apache.daffodil.runtime1.api.InfosetSimpleElement;
import org.smooks.cartridges.dfdl.parser.ParserDfdlSmooksException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import scala.xml.NamespaceBinding;

class ContentHandlerInfosetOutputter
extends InfosetOutputter {
    protected static final char[] INDENT = "\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t".toCharArray();
    protected final ContentHandler contentHandler;
    protected final boolean indent;
    protected int elementLevel = 0;
    protected Stack<NamespaceBinding> namespaceBindings = new Stack();
    protected Throwable contentHandlerThrowable;

    ContentHandlerInfosetOutputter(ContentHandler contentHandler, boolean indent) {
        this.contentHandler = contentHandler;
        this.indent = indent;
    }

    public void reset() {
    }

    public void startDocument() {
        try {
            this.contentHandler.startDocument();
        }
        catch (Throwable e) {
            this.contentHandlerThrowable = e;
            throw new ParserDfdlSmooksException(e.getMessage(), e);
        }
    }

    public void endDocument() {
        try {
            this.contentHandler.endDocument();
        }
        catch (Throwable e) {
            this.contentHandlerThrowable = e;
            throw new ParserDfdlSmooksException(e.getMessage(), e);
        }
    }

    public void startSimple(InfosetSimpleElement simple) {
        try {
            AttributesImpl attributes = this.createAttributes((InfosetElement)simple);
            if (simple.isNilled()) {
                attributes.addAttribute("http://www.w3.org/2000/xmlns/", "xsi", "xmlns:xsi", "NMTOKEN", "http://www.w3.org/2001/XMLSchema-instance");
                attributes.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi:nil", "NMTOKEN", "true");
            }
            this.indent(this.elementLevel);
            this.contentHandler.startElement(this.getNamespaceUri((InfosetElement)simple), simple.metadata().name(), this.getQName((InfosetElement)simple), attributes);
            if (!simple.isNilled()) {
                this.contentHandler.characters(simple.getText().toCharArray(), 0, simple.getText().length());
            }
        }
        catch (Throwable e) {
            this.contentHandlerThrowable = e;
            throw new ParserDfdlSmooksException(e.getMessage(), e);
        }
    }

    public void endSimple(InfosetSimpleElement simple) {
        try {
            if (simple.metadata().prefix() != null) {
                this.namespaceBindings.pop();
            }
            this.contentHandler.endElement(this.getNamespaceUri((InfosetElement)simple), simple.metadata().name(), this.getQName((InfosetElement)simple));
        }
        catch (Throwable e) {
            this.contentHandlerThrowable = e;
            throw new ParserDfdlSmooksException(e.getMessage(), e);
        }
    }

    public void startComplex(InfosetComplexElement complex) {
        try {
            this.indent(this.elementLevel);
            String nsUri = this.getNamespaceUri((InfosetElement)complex);
            this.contentHandler.startElement(nsUri, complex.metadata().name(), this.getQName((InfosetElement)complex), this.createAttributes((InfosetElement)complex));
            ++this.elementLevel;
            if (complex.isNilled()) {
                --this.elementLevel;
                if (complex.metadata().prefix() != null) {
                    this.namespaceBindings.pop();
                }
                this.contentHandler.endElement(nsUri, complex.metadata().name(), this.getQName((InfosetElement)complex));
            }
        }
        catch (Throwable e) {
            this.contentHandlerThrowable = e;
            throw new ParserDfdlSmooksException(e.getMessage(), e);
        }
    }

    protected AttributesImpl createAttributes(InfosetElement infosetElement) {
        AttributesImpl attributes = new AttributesImpl();
        if (infosetElement.metadata().prefix() != null) {
            NamespaceBinding namespaceBinding = infosetElement.metadata().minimizedScope();
            if (!this.namespaceBindings.contains(namespaceBinding)) {
                attributes.addAttribute("http://www.w3.org/2000/xmlns/", namespaceBinding.prefix(), "xmlns:" + namespaceBinding.prefix(), "CDATA", namespaceBinding.uri());
            }
            this.namespaceBindings.push(namespaceBinding);
        }
        return attributes;
    }

    public void endComplex(InfosetComplexElement complex) {
        try {
            --this.elementLevel;
            this.indent(this.elementLevel);
            if (complex.metadata().prefix() != null) {
                this.namespaceBindings.pop();
            }
            this.contentHandler.endElement(complex.metadata().namespace(), complex.metadata().name(), this.getQName((InfosetElement)complex));
        }
        catch (Throwable e) {
            this.contentHandlerThrowable = e;
            throw new ParserDfdlSmooksException(e.getMessage(), e);
        }
    }

    public void startArray(InfosetArray array) {
    }

    public void endArray(InfosetArray array) {
    }

    protected String getQName(InfosetElement infosetElement) {
        String prefix = infosetElement.metadata().prefix();
        return prefix == null || prefix.isEmpty() ? "" : prefix + ":" + infosetElement.metadata().name();
    }

    protected void indent(int elementLevel) throws SAXException {
        if (this.indent) {
            this.contentHandler.characters(INDENT, 0, elementLevel + 1);
        }
    }

    protected String getNamespaceUri(InfosetElement infosetElement) {
        return infosetElement.metadata().namespace() == null ? "" : infosetElement.metadata().namespace();
    }

    public Throwable getContentHandlerThrowable() {
        return this.contentHandlerThrowable;
    }
}

