/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.text.MessageFormat;
import junit.framework.TestCase;
import org.slf4j.helpers.BogoPerf;
import org.slf4j.helpers.MessageFormatter;

public class MessageFormatterPerfTest
extends TestCase {
    Integer i1 = new Integer(1);
    static long RUN_LENGTH = 100000L;
    static long REFERENCE_BIPS = 9000L;

    public MessageFormatterPerfTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void XtestJDKFormatterPerf() {
        this.jdkMessageFormatter(RUN_LENGTH);
        double duration = this.jdkMessageFormatter(RUN_LENGTH);
        System.out.println("jdk duration = " + duration + " nanos");
    }

    public void testSLF4JPerf() {
        this.slf4jMessageFormatter(RUN_LENGTH);
        double duration = this.slf4jMessageFormatter(RUN_LENGTH);
        long referencePerf = 140L;
        BogoPerf.assertDuration(duration, referencePerf, REFERENCE_BIPS);
    }

    public double slf4jMessageFormatter(long len) {
        String s = "";
        s = s + "";
        long start = System.currentTimeMillis();
        int i = 0;
        while ((long)i < len) {
            s = MessageFormatter.format((String)"This is some rather short message {} ", (Object)this.i1);
            ++i;
        }
        long end = System.currentTimeMillis();
        return 1.0 * (double)end - (double)start;
    }

    public double jdkMessageFormatter(long len) {
        String s = "";
        s = s + "";
        long start = System.currentTimeMillis();
        Object[] oa = new Object[]{this.i1};
        int i = 0;
        while ((long)i < len) {
            s = MessageFormat.format("This is some rather short message {0}", oa);
            ++i;
        }
        long end = System.currentTimeMillis();
        return 1.0 * (double)end - (double)start;
    }
}

