/*
 * Decompiled with CFR 0.152.
 */
package org.sisioh.akka.cluster.custom.downing.strategy.oldest;

import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.cluster.MemberStatus;
import java.io.Serializable;
import org.sisioh.akka.cluster.custom.downing.SplitBrainResolver;
import org.sisioh.akka.cluster.custom.downing.strategy.CustomAutoDownBase;
import org.sisioh.akka.cluster.custom.downing.strategy.oldest.SortedMembersByOldest;
import org.sisioh.akka.cluster.custom.downing.strategy.oldest.SortedMembersByOldest$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.collection.immutable.SortedSet;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c!B\n\u0015\u0003\u0003)\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u000be\u0002A\u0011\u0001\u001e\t\u000fy\u0002\u0001\u0019!C\u0005\u007f!91\t\u0001a\u0001\n\u0013!\u0005BB&\u0001A\u0003&\u0001\tC\u0003M\u0001\u0011ES\nC\u0003X\u0001\u0011E\u0003\fC\u0003k\u0001\u0011E1\u000eC\u0003s\u0001\u0011E1\u000fC\u0003v\u0001\u0011Ea\u000fC\u0003{\u0001\u0011E1\u0010C\u0003~\u0001\u0011Ea\u0010\u0003\u0004~\u0001\u0011E\u0011\u0011\u0004\u0005\b\u0003C\u0001A\u0011CA\u0012\u0011\u001d\t9\u0003\u0001C\t\u0003SAq!!\f\u0001\t#\ty\u0003C\u0004\u00026\u0001!I!a\u000e\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>\tir\n\u001c3fgR\fu/\u0019:f\u0007V\u001cHo\\7BkR|Gi\\<o\u0005\u0006\u001cXM\u0003\u0002\u0016-\u00051q\u000e\u001c3fgRT!a\u0006\r\u0002\u0011M$(/\u0019;fOfT!!\u0007\u000e\u0002\u000f\u0011|wO\\5oO*\u00111\u0004H\u0001\u0007GV\u001cHo\\7\u000b\u0005uq\u0012aB2mkN$XM\u001d\u0006\u0003?\u0001\nA!Y6lC*\u0011\u0011EI\u0001\u0007g&\u001c\u0018n\u001c5\u000b\u0003\r\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0014+!\t9\u0003&D\u0001\u0017\u0013\tIcC\u0001\nDkN$x.\\!vi>$un\u001e8CCN,\u0007CA\u0016-\u001b\u0005A\u0012BA\u0017\u0019\u0005I\u0019\u0006\u000f\\5u\u0005J\f\u0017N\u001c*fg>dg/\u001a:\u00021\u0005,Ho\u001c#po:,fN]3bG\"\f'\r\\3BMR,'\u000f\u0005\u00021o5\t\u0011G\u0003\u00023g\u0005AA-\u001e:bi&|gN\u0003\u00025k\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u0019\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"\"aO\u001f\u0011\u0005q\u0002Q\"\u0001\u000b\t\u000b9\u0012\u0001\u0019A\u0018\u0002\u00195,WNY3sg\nK\u0018iZ3\u0016\u0003\u0001\u0003\"\u0001P!\n\u0005\t#\"!F*peR,G-T3nE\u0016\u00148OQ=PY\u0012,7\u000f^\u0001\u0011[\u0016l'-\u001a:t\u0005f\fu-Z0%KF$\"!R%\u0011\u0005\u0019;U\"A\u001b\n\u0005!+$\u0001B+oSRDqA\u0013\u0003\u0002\u0002\u0003\u0007\u0001)A\u0002yIE\nQ\"\\3nE\u0016\u00148OQ=BO\u0016\u0004\u0013\u0001\u0004:fG\u0016Lg/Z#wK:$X#\u0001(\u0011\u0005=\u0003V\"\u0001\u0001\n\u0005E\u0013&a\u0002*fG\u0016Lg/Z\u0005\u0003'R\u0013Q!Q2u_JT!!\u0016,\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003}\t!\"\u001b8ji&\fG.\u001b>f)\t)\u0015\fC\u0003[\u000f\u0001\u00071,A\u0003ti\u0006$X\r\u0005\u0002]O:\u0011Q\f\u001a\b\u0003=\u000et!a\u00182\u000e\u0003\u0001T!!\u0019\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0012BA\u000fW\u0013\t)g-\u0001\u0007DYV\u001cH/\u001a:Fm\u0016tGO\u0003\u0002\u001e-&\u0011\u0001.\u001b\u0002\u0014\u0007V\u0014(/\u001a8u\u00072,8\u000f^3s'R\fG/\u001a\u0006\u0003K\u001a\fQB]3qY\u0006\u001cW-T3nE\u0016\u0014HCA#m\u0011\u0015i\u0007\u00021\u0001o\u0003\u0019iW-\u001c2feB\u0011q\u000e]\u0007\u0002M&\u0011\u0011O\u001a\u0002\u0007\u001b\u0016l'-\u001a:\u0002\u0019I,Wn\u001c<f\u001b\u0016l'-\u001a:\u0015\u0005\u0015#\b\"B7\n\u0001\u0004q\u0017\u0001C5t\u001f2$Wm\u001d;\u0016\u0003]\u0004\"A\u0012=\n\u0005e,$a\u0002\"p_2,\u0017M\\\u0001\u0010SN|E\u000eZ3ti^KG\u000f[8viR\u0011q\u000f \u0005\u0006[.\u0001\rA\\\u0001\u000bSN|E\u000eZ3ti>3GCA<\u0000\u0011\u001d\t\t\u0001\u0004a\u0001\u0003\u0007\tAA]8mKB)a)!\u0002\u0002\n%\u0019\u0011qA\u001b\u0003\r=\u0003H/[8o!\u0011\tY!a\u0005\u000f\t\u00055\u0011q\u0002\t\u0003?VJ1!!\u00056\u0003\u0019\u0001&/\u001a3fM&!\u0011QCA\f\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011C\u001b\u0015\u000b]\fY\"!\b\t\u000f\u0005\u0005Q\u00021\u0001\u0002\u0004!1\u0011qD\u0007A\u00029\fqa^5uQ>,H/A\u0007jg>cG-Z:u\u00032|g.\u001a\u000b\u0004o\u0006\u0015\u0002bBA\u0001\u001d\u0001\u0007\u00111A\u0001\u0012SN\u001cVmY8oI\u0006\u0014\u0018p\u00147eKN$HcA<\u0002,!9\u0011\u0011A\bA\u0002\u0005\r\u0011\u0001D8mI\u0016\u001cH/T3nE\u0016\u0014H\u0003BA\u0019\u0003g\u0001BARA\u0003]\"9\u0011\u0011\u0001\tA\u0002\u0005\r\u0011\u0001B5t\u001f.#2a^A\u001d\u0011\u0015i\u0017\u00031\u0001o\u0003\u0011I7oS(\u0015\u0007]\fy\u0004C\u0003n%\u0001\u0007a\u000e")
public abstract class OldestAwareCustomAutoDownBase
extends CustomAutoDownBase
implements SplitBrainResolver {
    private SortedMembersByOldest membersByAge = SortedMembersByOldest$.MODULE$.empty();

    private SortedMembersByOldest membersByAge() {
        return this.membersByAge;
    }

    private void membersByAge_$eq(SortedMembersByOldest x$1) {
        this.membersByAge = x$1;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receiveEvent() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ OldestAwareCustomAutoDownBase $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ClusterEvent.MemberUp) {
                    ClusterEvent.MemberUp memberUp = (ClusterEvent.MemberUp)A1;
                    Member m = memberUp.member();
                    this.$outer.log().info("{} is up", (Object)m);
                    this.$outer.replaceMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.UnreachableMember) {
                    ClusterEvent.UnreachableMember unreachableMember = (ClusterEvent.UnreachableMember)A1;
                    Member m = unreachableMember.member();
                    this.$outer.log().info("{} is unreachable", (Object)m);
                    this.$outer.replaceMember(m);
                    this.$outer.addUnreachableMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.ReachableMember) {
                    ClusterEvent.ReachableMember reachableMember = (ClusterEvent.ReachableMember)A1;
                    Member m = reachableMember.member();
                    this.$outer.log().info("{} is reachable", (Object)m);
                    this.$outer.replaceMember(m);
                    this.$outer.removeUnreachableMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberLeft) {
                    ClusterEvent.MemberLeft memberLeft = (ClusterEvent.MemberLeft)A1;
                    Member m = memberLeft.member();
                    this.$outer.log().info("{} is left the cluster", (Object)m);
                    this.$outer.replaceMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberExited) {
                    ClusterEvent.MemberExited memberExited = (ClusterEvent.MemberExited)A1;
                    Member m = memberExited.member();
                    this.$outer.log().info("{} exited the cluster", (Object)m);
                    this.$outer.replaceMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberDowned) {
                    ClusterEvent.MemberDowned memberDowned = (ClusterEvent.MemberDowned)A1;
                    Member m = memberDowned.member();
                    this.$outer.log().info("{} was downed", (Object)m);
                    this.$outer.replaceMember(m);
                    this.$outer.onMemberDowned(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    MemberStatus prev = memberRemoved.previousStatus();
                    this.$outer.log().info("{} was removed from the cluster", (Object)m);
                    this.$outer.removeUnreachableMember(m);
                    this.$outer.removeMember(m);
                    this.$outer.onMemberRemoved(m, prev);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof ClusterEvent.MemberUp ? true : (object instanceof ClusterEvent.UnreachableMember ? true : (object instanceof ClusterEvent.ReachableMember ? true : (object instanceof ClusterEvent.MemberLeft ? true : (object instanceof ClusterEvent.MemberExited ? true : (object instanceof ClusterEvent.MemberDowned ? true : object instanceof ClusterEvent.MemberRemoved)))));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    @Override
    public void initialize(ClusterEvent.CurrentClusterState state) {
        this.log().debug("initialize: {}", (Object)state);
        this.membersByAge_$eq(SortedMembersByOldest$.MODULE$.apply((SortedSet<Member>)state.members()));
    }

    public void replaceMember(Member member) {
        this.membersByAge_$eq((SortedMembersByOldest)this.membersByAge().replace(member));
    }

    public void removeMember(Member member) {
        this.membersByAge_$eq((SortedMembersByOldest)this.membersByAge().$minus(member));
    }

    public boolean isOldest() {
        return this.membersByAge().isOldest(this.selfAddress());
    }

    public boolean isOldestWithout(Member member) {
        return this.membersByAge().isOldestWithout(this.selfAddress(), member);
    }

    public boolean isOldestOf(Option<String> role) {
        return this.membersByAge().isOldestOf(this.selfAddress(), role);
    }

    public boolean isOldestOf(Option<String> role, Member without) {
        return this.membersByAge().isOldestOf(this.selfAddress(), role);
    }

    public boolean isOldestAlone(Option<String> role) {
        return this.membersByAge().isOldestAlone(this.selfAddress(), role, (Function1<Member, Object>)(Function1 & Serializable)member -> BoxesRunTime.boxToBoolean((boolean)this.isOK(member)), (Function1<Member, Object>)(Function1 & Serializable)member -> BoxesRunTime.boxToBoolean((boolean)this.isKO(member)));
    }

    public boolean isSecondaryOldest(Option<String> role) {
        return this.membersByAge().isSecondaryOldest(this.selfAddress(), role);
    }

    public Option<Member> oldestMember(Option<String> role) {
        return this.membersByAge().oldestMember(role);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isOK(Member member) {
        MemberStatus memberStatus = member.status();
        MemberStatus.Up$ up$ = MemberStatus.Up$.MODULE$;
        if (memberStatus == null ? up$ != null : !memberStatus.equals(up$)) {
            MemberStatus memberStatus2 = member.status();
            MemberStatus.Leaving$ leaving$ = MemberStatus.Leaving$.MODULE$;
            if (memberStatus2 == null) {
                if (leaving$ != null) {
                    return false;
                }
            } else if (!memberStatus2.equals(leaving$)) return false;
        }
        if (this.pendingUnreachableMembers().contains(member)) return false;
        if (this.unstableUnreachableMembers().contains(member)) return false;
        return true;
    }

    private boolean isKO(Member member) {
        return !this.isOK(member);
    }

    public OldestAwareCustomAutoDownBase(FiniteDuration autoDownUnreachableAfter) {
        super(autoDownUnreachableAfter);
    }
}

