/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.io.IOException;
import org.simpleframework.common.thread.Scheduler;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.socket.Session;
import org.simpleframework.http.socket.service.FrameConnection;
import org.simpleframework.http.socket.service.ResponseBuilder;
import org.simpleframework.http.socket.service.StatusChecker;
import org.simpleframework.transport.reactor.Reactor;

class SessionBuilder {
    private final Scheduler scheduler;
    private final Reactor reactor;
    private final long ping;

    public SessionBuilder(Scheduler scheduler, Reactor reactor, long ping) {
        this.scheduler = scheduler;
        this.reactor = reactor;
        this.ping = ping;
    }

    public Session create(Request request, Response response) throws Exception {
        FrameConnection connection = new FrameConnection(request, response, this.reactor);
        ResponseBuilder builder = new ResponseBuilder(request, response);
        StatusChecker checker = new StatusChecker(connection, request, this.scheduler, this.ping);
        try {
            builder.commit();
            checker.start();
        }
        catch (Exception e) {
            throw new IOException("Could not send response", e);
        }
        return connection.open();
    }
}

