/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.io.IOException;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.socket.service.Router;
import org.simpleframework.http.socket.service.Service;
import org.simpleframework.http.socket.service.ServiceDispatcher;

public class RouterContainer
implements Container {
    private final ServiceDispatcher dispatcher;
    private final Container container;
    private final Router router;

    public RouterContainer(Container container, Router router, int threads) throws IOException {
        this(container, router, threads, 10000L);
    }

    public RouterContainer(Container container, Router router, int threads, long ping) throws IOException {
        this.dispatcher = new ServiceDispatcher(router, threads, ping);
        this.container = container;
        this.router = router;
    }

    public void handle(Request req, Response resp) {
        Service service = this.router.route(req, resp);
        if (service != null) {
            this.dispatcher.dispatch(req, resp);
        } else {
            this.container.handle(req, resp);
        }
    }
}

