/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.io.IOException;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.Status;
import org.simpleframework.http.socket.service.AcceptToken;
import org.simpleframework.http.socket.service.RequestValidator;
import org.simpleframework.http.socket.service.ServiceEvent;
import org.simpleframework.transport.ByteWriter;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.trace.Trace;

class ResponseBuilder {
    private final RequestValidator validator;
    private final AcceptToken token;
    private final ByteWriter writer;
    private final Response response;
    private final Channel channel;
    private final Trace trace;

    public ResponseBuilder(Request request, Response response) throws Exception {
        this.validator = new RequestValidator(request);
        this.token = new AcceptToken(request);
        this.channel = request.getChannel();
        this.writer = this.channel.getWriter();
        this.trace = this.channel.getTrace();
        this.response = response;
    }

    public void commit() throws IOException {
        if (this.validator.isValid()) {
            this.accept();
        } else {
            this.reject();
        }
    }

    private void reject() throws IOException {
        long time = System.currentTimeMillis();
        this.response.setStatus(Status.BAD_REQUEST);
        this.response.setValue("Connection", "close");
        this.response.setDate("Date", time);
        String header = this.response.toString();
        byte[] message = header.getBytes("UTF-8");
        this.trace.trace((Object)ServiceEvent.WRITE_HEADER, (Object)header);
        this.writer.write(message);
        this.writer.flush();
        this.writer.close();
    }

    private void accept() throws IOException {
        long time = System.currentTimeMillis();
        String accept = this.token.create();
        this.response.setStatus(Status.SWITCHING_PROTOCOLS);
        this.response.setDescription("Upgrade");
        this.response.setValue("Connection", "Upgrade");
        this.response.setDate("Date", time);
        this.response.setValue("Sec-WebSocket-Accept", accept);
        this.response.setValue("Upgrade", "websocket");
        String header = this.response.toString();
        byte[] message = header.getBytes("UTF-8");
        this.trace.trace((Object)ServiceEvent.WRITE_HEADER, (Object)header);
        this.writer.write(message);
        this.writer.flush();
    }
}

