/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.simpleframework.http.Request;
import org.simpleframework.transport.ByteWriter;
import org.simpleframework.transport.Channel;

class OutputBarrier {
    private final ReentrantLock lock = new ReentrantLock();
    private final ByteWriter writer;
    private final Channel channel;
    private final long duration;

    public OutputBarrier(Request request, long duration) {
        this.channel = request.getChannel();
        this.writer = this.channel.getWriter();
        this.duration = duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte[] frame) throws IOException {
        try {
            if (!this.lock.tryLock(this.duration, TimeUnit.MILLISECONDS)) {
                throw new IOException("Transport lock could not be acquired");
            }
            try {
                this.writer.write(frame);
                this.writer.flush();
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception e) {
            throw new IOException("Error writing to transport", e);
        }
    }
}

