/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.io.IOException;
import org.simpleframework.http.socket.FrameType;
import org.simpleframework.http.socket.service.FrameHeader;
import org.simpleframework.transport.ByteCursor;

class FrameHeaderConsumer
implements FrameHeader {
    private FrameType type;
    private boolean masked;
    private boolean last;
    private byte[] mask;
    private byte[] octet = new byte[1];
    private int required;
    private int length = -1;
    private int count;

    public FrameHeaderConsumer() {
        this.mask = new byte[4];
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getMask() {
        return this.mask;
    }

    public FrameType getType() {
        return this.type;
    }

    public boolean isMasked() {
        return this.masked;
    }

    public boolean isFinal() {
        return this.last;
    }

    public void consume(ByteCursor cursor) throws IOException {
        if (cursor.isReady()) {
            if (this.type == null) {
                int count = cursor.read(this.octet);
                if (count <= 0) {
                    throw new IOException("Ready cursor produced no data");
                }
                this.type = FrameType.resolveType(this.octet[0] & 0xF);
                if (this.type == null) {
                    throw new IOException("Frame type code not supported");
                }
                this.last = (this.octet[0] & 0x80) != 0;
            } else if (this.length < 0) {
                int count = cursor.read(this.octet);
                if (count <= 0) {
                    throw new IOException("Ready cursor produced no data");
                }
                this.masked = (this.octet[0] & 0x80) != 0;
                this.length = this.octet[0] & 0x7F;
                if (this.length == 127) {
                    this.required = 8;
                    this.length = 0;
                } else if (this.length == 126) {
                    this.required = 2;
                    this.length = 0;
                }
            } else if (this.required > 0) {
                int count = cursor.read(this.octet);
                if (count == -1) {
                    throw new IOException("Could not read length");
                }
                this.length |= (this.octet[0] & 0xFF) << 8 * --this.required;
            } else if (this.masked && this.count < this.mask.length) {
                int size = cursor.read(this.mask, this.count, this.mask.length - this.count);
                if (size == -1) {
                    throw new IOException("Could not read mask");
                }
                this.count += size;
            }
        }
    }

    public boolean isFinished() {
        if (this.type != null && this.length >= 0 && this.required == 0) {
            if (this.masked) {
                return this.count == this.mask.length;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this.type = null;
        this.length = -1;
        this.required = 0;
        this.masked = false;
        this.count = 0;
    }
}

