/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.io.IOException;
import java.security.MessageDigest;
import org.simpleframework.common.encode.Base64Encoder;
import org.simpleframework.http.Request;

class AcceptToken {
    private static final byte[] MAGIC = new byte[]{50, 53, 56, 69, 65, 70, 65, 53, 45, 69, 57, 49, 52, 45, 52, 55, 68, 65, 45, 57, 53, 67, 65, 45, 67, 53, 65, 66, 48, 68, 67, 56, 53, 66, 49, 49};
    private final MessageDigest digest;
    private final Request request;
    private final String charset;

    public AcceptToken(Request request) throws Exception {
        this(request, "SHA-1");
    }

    public AcceptToken(Request request, String algorithm) throws Exception {
        this(request, algorithm, "UTF-8");
    }

    public AcceptToken(Request request, String algorithm, String charset) throws Exception {
        this.digest = MessageDigest.getInstance(algorithm);
        this.request = request;
        this.charset = charset;
    }

    public String create() throws IOException {
        String value = this.request.getValue("Sec-WebSocket-Key");
        byte[] data = value.getBytes(this.charset);
        if (data.length > 0) {
            this.digest.update(data);
            this.digest.update(MAGIC);
        }
        byte[] digested = this.digest.digest();
        char[] text = Base64Encoder.encode((byte[])digested);
        return new String(text);
    }
}

