/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.message;

import org.simpleframework.common.buffer.Allocator;
import org.simpleframework.http.ContentType;
import org.simpleframework.http.message.BodyConsumer;
import org.simpleframework.http.message.ChunkedConsumer;
import org.simpleframework.http.message.EmptyConsumer;
import org.simpleframework.http.message.FileUploadConsumer;
import org.simpleframework.http.message.FixedLengthConsumer;
import org.simpleframework.http.message.Segment;

class ConsumerFactory {
    protected Allocator allocator;
    protected Segment segment;

    public ConsumerFactory(Allocator allocator, Segment segment) {
        this.allocator = allocator;
        this.segment = segment;
    }

    public BodyConsumer getInstance() {
        long length = this.getContentLength();
        if (length < 0L) {
            return this.getInstance(8192L);
        }
        return this.getInstance(length);
    }

    public BodyConsumer getInstance(long length) {
        byte[] boundary = this.getBoundary(this.segment);
        if (this.isUpload(this.segment)) {
            return new FileUploadConsumer(this.allocator, boundary, length);
        }
        if (this.isChunked(this.segment)) {
            return new ChunkedConsumer(this.allocator);
        }
        if (this.isFixed(this.segment)) {
            return new FixedLengthConsumer(this.allocator, length);
        }
        return new EmptyConsumer();
    }

    protected byte[] getBoundary(Segment header) {
        String token;
        ContentType type = header.getContentType();
        if (type != null && (token = type.getParameter("boundary")) != null) {
            return token.getBytes();
        }
        return null;
    }

    protected boolean isUpload(Segment segment) {
        String token;
        ContentType type = segment.getContentType();
        return type != null && (token = type.getPrimary()).equals("multipart");
    }

    protected boolean isChunked(Segment segment) {
        String encoding = segment.getTransferEncoding();
        return encoding != null && encoding.equals("chunked");
    }

    protected boolean isFixed(Segment segment) {
        long length = segment.getContentLength();
        return length > 0L;
    }

    protected long getContentLength() {
        return this.segment.getContentLength();
    }
}

