/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.BodyEncoder;
import org.simpleframework.http.core.BodyEncoderFactory;
import org.simpleframework.http.core.BodyObserver;
import org.simpleframework.http.core.ContainerEvent;
import org.simpleframework.http.core.Conversation;
import org.simpleframework.http.core.ResponseException;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.trace.Trace;

class ResponseEncoder {
    private BodyEncoderFactory factory;
    private Conversation support;
    private Response response;
    private BodyEncoder encoder;
    private Trace trace;

    public ResponseEncoder(BodyObserver observer, Response response, Conversation support, Channel channel) {
        this.factory = new BodyEncoderFactory(observer, support, channel);
        this.trace = channel.getTrace();
        this.response = response;
        this.support = support;
    }

    public boolean isStarted() {
        return this.encoder != null;
    }

    public void start() throws IOException {
        if (this.encoder != null) {
            throw new ResponseException("Transfer has already started");
        }
        this.clear();
        this.configure();
        this.commit();
    }

    public void start(int length) throws IOException {
        if (this.encoder != null) {
            throw new ResponseException("Transfer has already started");
        }
        this.clear();
        this.configure(length);
        this.commit();
    }

    public void write(byte[] array) throws IOException {
        this.write(array, 0, array.length);
    }

    public void write(byte[] array, int off, int len) throws IOException {
        if (this.encoder == null) {
            throw new ResponseException("Conversation details not ready");
        }
        this.trace.trace((Object)ContainerEvent.WRITE_BODY, (Object)len);
        this.encoder.encode(array, off, len);
    }

    public void write(ByteBuffer buffer) throws IOException {
        int size;
        int mark = buffer.position();
        if (mark > (size = buffer.limit())) {
            throw new ResponseException("Buffer position greater than limit");
        }
        this.write(buffer, 0, size - mark);
    }

    public void write(ByteBuffer buffer, int off, int len) throws IOException {
        if (this.encoder == null) {
            throw new ResponseException("Conversation details not ready");
        }
        this.trace.trace((Object)ContainerEvent.WRITE_BODY, (Object)len);
        this.encoder.encode(buffer, off, len);
    }

    public void flush() throws IOException {
        if (this.encoder == null) {
            throw new ResponseException("Conversation details not ready");
        }
        this.encoder.flush();
    }

    public void close() throws IOException {
        if (this.encoder == null) {
            throw new ResponseException("Conversation details not ready");
        }
        this.encoder.close();
    }

    private void configure() throws IOException {
        long length = this.support.getContentLength();
        boolean empty = this.support.isEmpty();
        boolean tunnel = this.support.isTunnel();
        if (tunnel) {
            this.support.setConnectionUpgrade();
        } else if (empty) {
            this.support.setContentLength(0L);
        } else if (length >= 0L) {
            this.support.setContentLength(length);
        } else {
            this.support.setChunkedEncoded();
        }
        this.encoder = this.factory.getInstance();
    }

    private void configure(long count) throws IOException {
        long length = this.support.getContentLength();
        if (this.support.isHead()) {
            if (count > 0L) {
                this.configure(count, count);
            } else {
                this.configure(count, length);
            }
        } else {
            this.configure(count, count);
        }
    }

    private void configure(long count, long length) throws IOException {
        boolean empty = this.support.isEmpty();
        boolean tunnel = this.support.isTunnel();
        if (tunnel) {
            this.support.setConnectionUpgrade();
        } else if (empty) {
            this.support.setContentLength(0L);
        } else if (length >= 0L) {
            this.support.setContentLength(length);
        } else {
            this.support.setChunkedEncoded();
        }
        this.encoder = this.factory.getInstance();
    }

    private void clear() throws IOException {
        this.support.setIdentityEncoded();
    }

    private void commit() throws IOException {
        try {
            this.response.commit();
        }
        catch (Exception cause) {
            throw new ResponseException("Unable to commit", cause);
        }
    }
}

