/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.nio.channels.SocketChannel;
import org.simpleframework.http.core.Collector;
import org.simpleframework.http.core.ContainerEvent;
import org.simpleframework.http.core.Controller;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.trace.Trace;

class RequestReader
implements Operation {
    private final Controller controller;
    private final Collector collector;
    private final Channel channel;
    private final Trace trace;

    public RequestReader(Controller controller, Collector collector) {
        this.channel = collector.getChannel();
        this.trace = this.channel.getTrace();
        this.collector = collector;
        this.controller = controller;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public SocketChannel getChannel() {
        return this.channel.getSocket();
    }

    public void run() {
        try {
            this.collector.collect(this.controller);
        }
        catch (Throwable cause) {
            this.trace.trace((Object)ContainerEvent.ERROR, (Object)cause);
            this.channel.close();
        }
    }

    public void cancel() {
        try {
            this.channel.close();
        }
        catch (Throwable cause) {
            this.trace.trace((Object)ContainerEvent.ERROR, (Object)cause);
        }
    }
}

