/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.simpleframework.common.buffer.Allocator;
import org.simpleframework.common.thread.ConcurrentExecutor;
import org.simpleframework.http.core.Collector;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.Controller;
import org.simpleframework.http.core.RequestCollector;
import org.simpleframework.http.core.RequestDispatcher;
import org.simpleframework.http.core.RequestReader;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.TransportException;
import org.simpleframework.transport.reactor.ExecutorReactor;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.reactor.Reactor;

class ContainerController
implements Controller {
    private final ConcurrentExecutor executor;
    private final ConcurrentExecutor collect;
    private final Allocator allocator;
    private final Container container;
    private final Reactor reactor;

    public ContainerController(Container container, Allocator allocator, int count, int select) throws IOException {
        this.executor = new ConcurrentExecutor(RequestDispatcher.class, count);
        this.collect = new ConcurrentExecutor(RequestReader.class, count);
        this.reactor = new ExecutorReactor((Executor)this.collect, select);
        this.allocator = allocator;
        this.container = container;
    }

    public void start(Channel channel) throws IOException {
        this.start(new RequestCollector(this.allocator, channel));
    }

    public void start(Collector collector) throws IOException {
        this.reactor.process((Operation)new RequestReader(this, collector));
    }

    public void select(Collector collector) throws IOException {
        this.reactor.process((Operation)new RequestReader(this, collector), 1);
    }

    public void ready(Collector collector) throws IOException {
        this.executor.execute((Runnable)new RequestDispatcher(this.container, this, collector));
    }

    public void stop() throws IOException {
        try {
            this.reactor.stop();
            this.executor.stop();
            this.collect.stop();
        }
        catch (Exception cause) {
            throw new TransportException("Error stopping", (Throwable)cause);
        }
    }
}

