/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.simpleframework.http.core.BodyEncoder;
import org.simpleframework.http.core.BodyEncoderException;
import org.simpleframework.http.core.BodyObserver;
import org.simpleframework.transport.ByteWriter;

class ChunkedEncoder
implements BodyEncoder {
    private byte[] size = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 13, 10};
    private byte[] index = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private byte[] zero = new byte[]{48, 13, 10, 13, 10};
    private BodyObserver observer;
    private ByteWriter writer;

    public ChunkedEncoder(BodyObserver observer, ByteWriter writer) {
        this.observer = observer;
        this.writer = writer;
    }

    public void encode(byte[] array) throws IOException {
        this.encode(array, 0, array.length);
    }

    public void encode(byte[] array, int off, int len) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(array, off, len);
        if (len > 0) {
            this.encode(buffer);
        }
    }

    public void encode(ByteBuffer buffer) throws IOException {
        int size;
        int mark = buffer.position();
        if (mark > (size = buffer.limit())) {
            throw new BodyEncoderException("Buffer position greater than limit");
        }
        this.encode(buffer, 0, size - mark);
    }

    public void encode(ByteBuffer buffer, int off, int len) throws IOException {
        int pos = 7;
        if (this.observer.isClosed()) {
            throw new BodyEncoderException("Stream has been closed");
        }
        if (len > 0) {
            for (int num = len; num > 0; num >>>= 4) {
                this.size[pos--] = this.index[num & 0xF];
            }
            try {
                this.writer.write(this.size, pos + 1, 9 - pos);
                this.writer.write(buffer, off, len);
                this.writer.write(this.size, 8, 2);
            }
            catch (Exception cause) {
                if (this.writer != null) {
                    this.observer.error(this.writer);
                }
                throw new BodyEncoderException("Error sending response", cause);
            }
        }
    }

    public void flush() throws IOException {
        try {
            if (!this.observer.isClosed()) {
                this.writer.flush();
            }
        }
        catch (Exception cause) {
            if (this.writer != null) {
                this.observer.close(this.writer);
            }
            throw new BodyEncoderException("Error sending response", cause);
        }
    }

    private void finish() throws IOException {
        try {
            this.writer.write(this.zero);
            this.observer.ready(this.writer);
        }
        catch (Exception cause) {
            if (this.writer != null) {
                this.observer.close(this.writer);
            }
            throw new BodyEncoderException("Error flushing response", cause);
        }
    }

    public void close() throws IOException {
        if (!this.observer.isClosed()) {
            this.finish();
        }
    }
}

