/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class Cookie {
    private CookieDate date = new CookieDate();
    private String name;
    private String value;
    private String path;
    private String domain;
    private boolean secure;
    private boolean protect;
    private boolean created;
    private int version;
    private int expiry;

    public Cookie(String name, String value) {
        this(name, value, "/");
    }

    public Cookie(String name, String value, boolean created) {
        this(name, value, "/", created);
    }

    public Cookie(String name, String value, String path) {
        this(name, value, path, false);
    }

    public Cookie(String name, String value, String path, boolean created) {
        this.created = created;
        this.value = value;
        this.name = name;
        this.path = path;
        this.version = 1;
        this.expiry = -1;
    }

    public boolean isNew() {
        return this.created;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isProtected() {
        return this.protect;
    }

    public void setProtected(boolean protect) {
        this.protect = protect;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public void setExpiry(int expiry) {
        this.expiry = expiry;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String toClientString() {
        return "$Version=" + this.version + "; " + this.name + "=" + this.value + (this.path == null ? "" : "; $Path=" + this.path) + (this.domain == null ? "" : "; $Domain=" + this.domain);
    }

    public String toString() {
        return this.name + "=" + this.value + "; version=" + this.version + (this.path == null ? "" : "; path=" + this.path) + (this.domain == null ? "" : "; domain=" + this.domain) + (this.expiry < 0 ? "" : "; expires=" + this.date.format(this.expiry)) + (this.expiry < 0 ? "" : "; max-age=" + this.expiry) + (this.secure ? "; secure" : "") + (this.protect ? "; httponly" : "");
    }

    private static class CookieDate {
        private static final String FORMAT = "EEE, dd-MMM-yyyy HH:mm:ss z";
        private static final String ZONE = "GMT";
        private final DateFormat format = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z");
        private final TimeZone zone = new SimpleTimeZone(0, "GMT");

        public String format(int seconds) {
            Calendar calendar = Calendar.getInstance(this.zone);
            Date date = this.convert(seconds);
            calendar.setTime(date);
            this.format.setCalendar(calendar);
            return this.format.format(date);
        }

        private Date convert(int seconds) {
            long now = System.currentTimeMillis();
            long duration = (long)seconds * 1000L;
            long time = now + duration;
            return new Date(time);
        }
    }
}

