/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.common.thread;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.simpleframework.common.thread.DaemonFactory;

class ExecutorQueue {
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private final ThreadPoolExecutor executor;
    private final ThreadFactory factory;

    public ExecutorQueue(Class type, int rest, int active) {
        this(type, rest, active, 120L, TimeUnit.SECONDS);
    }

    public ExecutorQueue(Class type, int rest, int active, long duration, TimeUnit unit) {
        this.factory = new DaemonFactory(type);
        this.executor = new ThreadPoolExecutor(rest, active, duration, unit, this.queue, this.factory);
    }

    public void execute(Runnable task) {
        this.executor.execute(task);
    }

    public void stop() {
        this.stop(60000L);
    }

    public void stop(long wait) {
        if (!this.executor.isTerminated()) {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(wait, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not stop pool", e);
            }
        }
    }
}

