/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.common.thread;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.simpleframework.common.thread.DaemonFactory;

public abstract class Daemon
implements Runnable {
    private final AtomicReference<Thread> reference = new AtomicReference();
    private final DaemonFactory factory;
    private final AtomicBoolean active;
    private final Runnable delegate = new RunnableDelegate(this);

    protected Daemon() {
        this.factory = new DaemonFactory();
        this.active = new AtomicBoolean();
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void start() {
        Class<?> type = this.getClass();
        if (!this.active.get()) {
            Thread thread = this.factory.newThread(this.delegate, type);
            this.reference.set(thread);
            this.active.set(true);
            thread.start();
        }
    }

    public void interrupt() {
        Thread thread = this.reference.get();
        if (thread != null) {
            thread.interrupt();
        }
    }

    public void stop() {
        this.active.set(false);
    }

    private class RunnableDelegate
    implements Runnable {
        private final Runnable task;

        public RunnableDelegate(Runnable task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.task.run();
            }
            finally {
                Daemon.this.reference.set(null);
                Daemon.this.active.set(false);
            }
        }
    }
}

