/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.common.encode;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.simpleframework.common.encode.Base64Encoder;

public class Base64OutputStream
extends OutputStream {
    private char[] encoded;
    private byte[] buffer;
    private byte[] temp;
    private int count;

    public Base64OutputStream() {
        this(1024);
    }

    public Base64OutputStream(int capacity) {
        this.buffer = new byte[capacity];
        this.temp = new byte[1];
    }

    public void write(int octet) throws IOException {
        this.temp[0] = (byte)octet;
        this.write(this.temp);
    }

    public void write(byte[] array, int offset, int length) throws IOException {
        if (this.encoded != null) {
            throw new IOException("Stream has been closed");
        }
        if (this.count + length > this.buffer.length) {
            this.expand(this.count + length);
        }
        System.arraycopy(array, offset, this.buffer, this.count, length);
        this.count += length;
    }

    private void expand(int capacity) throws IOException {
        int length = Math.max(this.buffer.length * 2, capacity);
        if (this.buffer.length < capacity) {
            this.buffer = Arrays.copyOf(this.buffer, length);
        }
    }

    public void close() throws IOException {
        if (this.encoded == null) {
            this.encoded = Base64Encoder.encode(this.buffer, 0, this.count);
        }
    }

    public String toString() {
        return new String(this.encoded);
    }
}

