/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.simpleflatmapper.util.Enumerable;

public class EnumerableIterator<T>
implements Iterator<T> {
    private final Enumerable<T> enumerable;
    private boolean fetch = false;
    private boolean hasValue = false;

    public EnumerableIterator(Enumerable<T> enumerable) {
        this.enumerable = enumerable;
    }

    @Override
    public boolean hasNext() {
        if (!this.fetch) {
            this.fetch();
        }
        return this.hasValue;
    }

    private void fetch() {
        this.hasValue = this.enumerable.next();
        this.fetch = true;
    }

    @Override
    public T next() {
        if (!this.fetch) {
            this.fetch();
        }
        if (this.hasValue) {
            this.fetch = false;
            this.hasValue = false;
            return this.enumerable.currentValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

